/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.logger;

import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import furny.ga.logger.StatisticsDBManager;
import furny.ga.logger.entities.EvaluationRunEntry;
import furny.ga.logger.entities.EventType;
import furny.ga.logger.entities.GeneEntry;
import furny.ga.logger.entities.IndividualEntry;
import furny.ga.logger.entities.LogEvent;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IPopulation;
import ga.core.logging.IGALogger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GADatabaseLogger
implements IGALogger<FurnLayoutIndividual> {
    private EvaluationRunEntry run;
    private final ExecutorService executor = Executors.newFixedThreadPool(4);

    public void evaluationStarted() {
        this.run = new EvaluationRunEntry();
        this.run.setStarted(new Date());
        StatisticsDBManager.getInstance().saveEvaluationRun(this.run, false);
    }

    public void allIndividualsEvaluated(int generation, IPopulation<FurnLayoutIndividual> population) {
    }

    public void populationInitiated(int generation, IPopulation<FurnLayoutIndividual> population) {
        final LogEvent event = new LogEvent(new Date(), this.run, EventType.POPULATION_INITIATED);
        final ArrayList<IndividualEntry> list = new ArrayList<IndividualEntry>();
        for (FurnLayoutIndividual ind : population) {
            HashSet<GeneEntry> genes = new HashSet<GeneEntry>();
            for (FurnEntry entry : ind.getFurnitures()) {
                genes.add(new GeneEntry(entry.getVector(), entry.getFurniture().getId()));
            }
            IndividualEntry indEntry = new IndividualEntry(generation, event, genes, ind.getFitness());
            list.add(indEntry);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StatisticsDBManager.getInstance().saveLogEvent(event);
                for (IndividualEntry indEntry : list) {
                    StatisticsDBManager.getInstance().saveIndividualEntry(indEntry);
                }
            }
        });
    }

    public void individualsSelected(int generation, IndividualList<FurnLayoutIndividual> individuals) {
        final LogEvent event = new LogEvent(new Date(), this.run, EventType.INDIVIDUALS_SELECTED);
        final ArrayList<IndividualEntry> list = new ArrayList<IndividualEntry>();
        for (FurnLayoutIndividual ind : individuals) {
            HashSet<GeneEntry> genes = new HashSet<GeneEntry>();
            for (FurnEntry entry : ind.getFurnitures()) {
                genes.add(new GeneEntry(entry.getVector(), entry.getFurniture().getId()));
            }
            IndividualEntry indEntry = new IndividualEntry(generation, event, genes, ind.getFitness());
            list.add(indEntry);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StatisticsDBManager.getInstance().saveLogEvent(event);
                for (IndividualEntry indEntry : list) {
                    StatisticsDBManager.getInstance().saveIndividualEntry(indEntry);
                }
            }
        });
    }

    public void individualsCrossed(int generation, IndividualList<FurnLayoutIndividual> individuals) {
        final LogEvent event = new LogEvent(new Date(), this.run, EventType.INDIVIDUALS_CROSSED);
        final ArrayList<IndividualEntry> list = new ArrayList<IndividualEntry>();
        for (FurnLayoutIndividual ind : individuals) {
            HashSet<GeneEntry> genes = new HashSet<GeneEntry>();
            for (FurnEntry entry : ind.getFurnitures()) {
                genes.add(new GeneEntry(entry.getVector(), entry.getFurniture().getId()));
            }
            IndividualEntry indEntry = new IndividualEntry(generation, event, genes, ind.getFitness());
            list.add(indEntry);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StatisticsDBManager.getInstance().saveLogEvent(event);
                for (IndividualEntry indEntry : list) {
                    StatisticsDBManager.getInstance().saveIndividualEntry(indEntry);
                }
            }
        });
    }

    public void individualsMutated(int generation, IndividualList<FurnLayoutIndividual> individuals) {
        final LogEvent event = new LogEvent(new Date(), this.run, EventType.INDIVIDUALS_MUTATED);
        final ArrayList<IndividualEntry> list = new ArrayList<IndividualEntry>();
        for (FurnLayoutIndividual ind : individuals) {
            HashSet<GeneEntry> genes = new HashSet<GeneEntry>();
            for (FurnEntry entry : ind.getFurnitures()) {
                genes.add(new GeneEntry(entry.getVector(), entry.getFurniture().getId()));
            }
            IndividualEntry indEntry = new IndividualEntry(generation, event, genes, ind.getFitness());
            list.add(indEntry);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StatisticsDBManager.getInstance().saveLogEvent(event);
                for (IndividualEntry indEntry : list) {
                    StatisticsDBManager.getInstance().saveIndividualEntry(indEntry);
                }
            }
        });
    }

    public void individualsInserted(int generation, IndividualList<FurnLayoutIndividual> individuals, IPopulation<FurnLayoutIndividual> population) {
        final LogEvent event = new LogEvent(new Date(), this.run, EventType.INDIVIDUALS_INSERTED);
        final ArrayList<IndividualEntry> list = new ArrayList<IndividualEntry>();
        for (FurnLayoutIndividual ind : population) {
            HashSet<GeneEntry> genes = new HashSet<GeneEntry>();
            for (FurnEntry entry : ind.getFurnitures()) {
                genes.add(new GeneEntry(entry.getVector(), entry.getFurniture().getId()));
            }
            IndividualEntry indEntry = new IndividualEntry(generation, event, genes, ind.getFitness());
            list.add(indEntry);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StatisticsDBManager.getInstance().saveLogEvent(event);
                for (IndividualEntry indEntry : list) {
                    StatisticsDBManager.getInstance().saveIndividualEntry(indEntry);
                }
            }
        });
    }

    public void individualSelectedForEvaluation(int generation, FurnLayoutIndividual individual) {
        final LogEvent event = new LogEvent(new Date(), this.run, EventType.INDIVIDUALS_SELECTED_FOR_EVALUATION);
        HashSet<GeneEntry> genes = new HashSet<GeneEntry>();
        for (FurnEntry entry : individual.getFurnitures()) {
            genes.add(new GeneEntry(entry.getVector(), entry.getFurniture().getId()));
        }
        final IndividualEntry indEntry = new IndividualEntry(generation, event, genes, individual.getFitness());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StatisticsDBManager.getInstance().saveLogEvent(event);
                StatisticsDBManager.getInstance().saveIndividualEntry(indEntry);
            }
        });
    }

    public void individualEvaluated(int generation, FurnLayoutIndividual individual) {
        final LogEvent event = new LogEvent(new Date(), this.run, EventType.INDIVIDUAL_EVALUATED);
        HashSet<GeneEntry> genes = new HashSet<GeneEntry>();
        for (FurnEntry entry : individual.getFurnitures()) {
            genes.add(new GeneEntry(entry.getVector(), entry.getFurniture().getId()));
        }
        final IndividualEntry indEntry = new IndividualEntry(generation, event, genes, individual.getFitness());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StatisticsDBManager.getInstance().saveLogEvent(event);
                StatisticsDBManager.getInstance().saveIndividualEntry(indEntry);
            }
        });
    }

    public void exit() {
        this.run.setEnded(new Date());
        StatisticsDBManager.getInstance().saveEvaluationRun(this.run, true);
        this.executor.shutdown();
        StatisticsDBManager.getInstance().exit();
        System.out.println("logger exited");
    }
}

