/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.logger;

import furny.ga.logger.StatisticsDBManager;
import furny.ga.logger.entities.EventType;
import furny.ga.logger.entities.IndividualEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsCache {
    private static final StatisticsCache INSTANCE = new StatisticsCache();
    private final Map<List<Object>, List<IndividualEntry>> individualCache = new HashMap<List<Object>, List<IndividualEntry>>();

    private StatisticsCache() {
    }

    public static StatisticsCache getInstance() {
        return INSTANCE;
    }

    public List<IndividualEntry> getIndiduals(Long runId, EventType ... types) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(runId);
        for (EventType type : types) {
            key.add((Object)type);
        }
        Collections.sort(key, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.hashCode() - o2.hashCode();
            }
        });
        List<IndividualEntry> list = this.individualCache.get(key);
        if (list == null) {
            list = StatisticsDBManager.getInstance().getIndividuals(runId, types);
            this.individualCache.put(key, list);
        }
        return list;
    }
}

