/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.logger;

import furny.ga.logger.entities.EvaluationRunEntry;
import furny.ga.logger.entities.EventType;
import furny.ga.logger.entities.GeneEntry;
import furny.ga.logger.entities.IndividualEntry;
import furny.ga.logger.entities.LogEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;

public final class StatisticsDBManager {
    private static final Logger LOGGER = Logger.getLogger(StatisticsDBManager.class.getName());
    private static final StatisticsDBManager INSTANCE = new StatisticsDBManager();
    private static final String PARAMETERS = ";PAGE_SIZE=8192;AUTO_SERVER=TRUE;MVCC=TRUE;LOCK_TIMEOUT=100;DB_CLOSE_DELAY=-1;CACHE_SIZE=131072";
    private EntityManagerFactory entityManagerFactory;

    private StatisticsDBManager() {
    }

    public static StatisticsDBManager getInstance() {
        return INSTANCE;
    }

    private EntityManager createEntityManager() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"furny");
        }
        return this.entityManagerFactory.createEntityManager();
    }

    public void setCustomFilename(String filename) {
        if (filename != null) {
            if (this.entityManagerFactory != null) {
                this.entityManagerFactory.close();
            }
            HashMap<String, String> dbProps = new HashMap<String, String>();
            dbProps.put("javax.persistence.jdbc.url", "jdbc:h2:" + filename + PARAMETERS);
            this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"statistics", dbProps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEvaluationRun(EvaluationRunEntry run, boolean merge) {
        EntityManager entityManager = this.createEntityManager();
        EvaluationRunEntry er = run;
        try {
            entityManager.getTransaction().begin();
            if (merge) {
                er = (EvaluationRunEntry)entityManager.merge((Object)er);
            } else {
                entityManager.persist((Object)er);
            }
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save evaluation run", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLogEvent(LogEvent event) {
        EntityManager entityManager = this.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            entityManager.persist((Object)event);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save log event", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGeneEntry(GeneEntry gene) {
        EntityManager entityManager = this.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            entityManager.persist((Object)gene);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save gene entry", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndividualEntry(IndividualEntry individual) {
        EntityManager entityManager = this.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            individual.setEvent((LogEvent)entityManager.merge((Object)individual.getEvent()));
            for (GeneEntry entry : individual.getGenes()) {
                entityManager.persist((Object)entry);
            }
            entityManager.persist((Object)individual);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to save gene entry", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getRunEntries() {
        EntityManager entityManager = this.createEntityManager();
        ArrayList<Long> result = null;
        try {
            entityManager.getTransaction().begin();
            TypedQuery q = entityManager.createQuery("SELECT id FROM EvaluationRunEntry", Long.class);
            q.setHint("org.hibernate.cacheable", (Object)true);
            result = q.getResultList();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to get furniture ids", e);
            entityManager.getTransaction().rollback();
            result = new ArrayList();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndividualEntry> getIndividuals(Long runId, EventType ... types) {
        EntityManager entityManager = this.createEntityManager();
        List result = null;
        try {
            StringBuilder sb = new StringBuilder("FROM IndividualEntry i WHERE i.event.evaluationRun.id=:id");
            if (types.length > 0) {
                sb.append(" AND (");
                for (int i = 0; i < types.length; ++i) {
                    if (i > 0) {
                        sb.append(" OR ");
                    }
                    sb.append("i.event.type=:type" + i);
                    if (i != types.length - 1) continue;
                    sb.append(')');
                }
            }
            entityManager.getTransaction().begin();
            TypedQuery q = entityManager.createQuery(sb.toString(), IndividualEntry.class);
            q.setParameter("id", (Object)runId);
            for (int i = 0; i < types.length; ++i) {
                q.setParameter("type" + i, (Object)types[i]);
            }
            q.setHint("org.hibernate.cacheable", (Object)true);
            result = q.getResultList();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to get furniture", e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
        return result;
    }

    public void exit() {
        this.entityManagerFactory.close();
    }

    public static void main(String[] args) {
        System.err.println(StatisticsDBManager.getInstance().getIndividuals(3L, EventType.POPULATION_INITIATED, EventType.INDIVIDUALS_INSERTED));
    }
}

