/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.logger.entities;

import furny.ga.logger.entities.GeneEntry;
import furny.ga.logger.entities.LogEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class IndividualEntry {
    private long id;
    private LogEvent event;
    private int generation;
    private Set<GeneEntry> genes = new HashSet<GeneEntry>();
    private Double fitness;

    private IndividualEntry() {
    }

    public IndividualEntry(int generation, LogEvent event, Collection<GeneEntry> c, Double fitness) {
        this.generation = generation;
        this.event = event;
        this.genes.addAll(c);
        if (fitness != null && fitness != Double.MIN_VALUE) {
            this.fitness = fitness;
        }
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    private void setId(long id) {
        this.id = id;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    public LogEvent getEvent() {
        return this.event;
    }

    public void setEvent(LogEvent event) {
        this.event = event;
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.EAGER)
    public Set<GeneEntry> getGenes() {
        return this.genes;
    }

    public void setGenes(Set<GeneEntry> genes) {
        this.genes = genes;
    }

    public Double getFitness() {
        return this.fitness;
    }

    public void setFitness(Double fitness) {
        this.fitness = fitness;
    }
}

