/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.operators;

import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.RoomVector;
import furny.ga.util.FurnLayoutIOUtil;
import furny.ga.util.FurnitureUtil;
import ga.core.goperators.IMutationOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.validation.GAContext;
import ga.view.interfaces.IPhenotypeSpace;

public class FurnLayoutMutationOp
extends ProbabilityOp
implements IMutationOp<FurnLayoutIndividual> {
    private static final int MAX_ROTATION = 3;
    private final int wTranslate = 50;

    public FurnLayoutMutationOp(int pMutate) {
        super(pMutate);
    }

    public FurnLayoutIndividual mutate(FurnLayoutIndividual individual, GAContext context) {
        if (this.doOperate()) {
            FurnLayoutIndividual newInd = individual.clone();
            for (FurnEntry entry : newInd.getFurnitures()) {
                if (this.getRandom().nextBoolean()) {
                    RoomVector vec = entry.getVector();
                    int translation = this.getRandom().nextInt(50) - 25;
                    if (this.getRandom().nextBoolean()) {
                        vec = vec.getTranslatedInstance(translation, 0);
                    }
                    if (this.getRandom().nextBoolean()) {
                        vec = vec.getTranslatedInstance(0, translation);
                    }
                    if (this.getRandom().nextBoolean()) {
                        vec = vec.getRotatedInstance(this.getRandom().nextInt(3) - 1);
                    }
                    entry.setVector(vec);
                    continue;
                }
                Object o = context.get((Object)"ValidationSpace");
                if (o != null && o instanceof IPhenotypeSpace) {
                    entry.setFurniture(FurnitureUtil.getOtherFurnitureBySimilarityRoulette(entry.getFurniture()));
                    continue;
                }
                throw new RuntimeException("Phenotype space not found in the ga context");
            }
            return newInd;
        }
        return individual;
    }

    public static void main(String[] args) {
        GAContext context = new GAContext();
        context.put("ValidationSpace", (Object)new PseudoSpace(10.0f, 10.0f));
        FurnLayoutIndividual ind = new FurnLayoutIndividual(context);
        ind.initRandomly();
        FurnLayoutMutationOp crossover = new FurnLayoutMutationOp(100);
        System.out.println("\n BEFORE\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind.getSimpleGenotype()));
        FurnLayoutIndividual newInd = crossover.mutate(ind, context);
        System.out.println("\n AFTER\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(newInd.getSimpleGenotype()));
    }
}

