/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.operators;

import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

public class OnePointCrossoverOp
extends ProbabilityOp
implements ICrossoverOp<FurnLayoutIndividual> {
    public OnePointCrossoverOp(int pCrossOver) {
        super(pCrossOver);
    }

    public IndividualList<FurnLayoutIndividual> crossover(FurnLayoutIndividual individual1, FurnLayoutIndividual individual2, GAContext context) {
        IndividualList list = new IndividualList();
        FurnLayoutIndividual ind1 = individual1.clone();
        FurnLayoutIndividual ind2 = individual2.clone();
        if (this.doOperate()) {
            FurnEntryList bigger;
            FurnEntryList smaller;
            if (ind1.getFurnitures().size() < ind2.getFurnitures().size()) {
                smaller = ind1.getFurnitures();
                bigger = ind2.getFurnitures();
            } else {
                smaller = ind2.getFurnitures();
                bigger = ind1.getFurnitures();
            }
            int iCut = this.getRandom().nextInt(smaller.size());
            for (int i = 0; i <= iCut; ++i) {
                smaller.set(i, bigger.set(i, smaller.get(i)));
            }
        }
        list.add((Object)ind1);
        list.add((Object)ind2);
        return list;
    }

    public static void main(String[] args) {
        GAContext context = new GAContext();
        context.put("ValidationSpace", (Object)new PseudoSpace(10.0f, 10.0f));
        FurnLayoutIndividual ind1 = new FurnLayoutIndividual(context);
        ind1.initRandomly();
        FurnLayoutIndividual ind2 = new FurnLayoutIndividual(context);
        ind2.initRandomly();
        OnePointCrossoverOp crossover = new OnePointCrossoverOp(100);
        System.out.println("\n PARENT 1\n");
        FurnLayoutIOUtil.printSimpleGenotype(ind1.getSimpleGenotype());
        System.out.println("\n PARENT 2\n");
        FurnLayoutIOUtil.printSimpleGenotype(ind2.getSimpleGenotype());
        IndividualList<FurnLayoutIndividual> list = crossover.crossover(ind1, ind2, context);
        for (int i = 0; i < list.size(); ++i) {
            FurnLayoutIndividual newInd = (FurnLayoutIndividual)list.get(i);
            System.out.println("\n CHILD " + (i + 1) + "\n");
            FurnLayoutIOUtil.printSimpleGenotype(newInd.getSimpleGenotype());
        }
    }
}

