/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.operators;

import furny.entities.Furniture;
import furny.furndb.FurnCache;
import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.RoomVector;
import furny.ga.util.FurnLayoutIOUtil;
import furny.ga.util.FurnitureUtil;
import ga.core.goperators.IMutationOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.validation.GAContext;
import ga.view.interfaces.IPhenotypeSpace;
import java.util.List;

public class RealMutationOp
extends ProbabilityOp
implements IMutationOp<FurnLayoutIndividual> {
    private final int pNewFurniture;
    private final int pRemoveFurniture;
    private int wID = 6;
    private int wTranslate = 40;
    private int wRotate = 2;

    public RealMutationOp(int pMutate, int wID, int wTranslate, int wRotate, int pNewFurniture, int pRemoveFurniture) {
        this(pMutate);
        this.wID = wID;
        this.wTranslate = wTranslate;
        this.wRotate = wRotate;
    }

    public RealMutationOp(int pMutate, int pNewFurniture, int pRemoveFurniture) {
        super(pMutate);
        this.pNewFurniture = pNewFurniture;
        this.pRemoveFurniture = pRemoveFurniture;
    }

    public RealMutationOp(int pMutate) {
        this(pMutate, 0, 0);
    }

    public FurnLayoutIndividual mutate(FurnLayoutIndividual individual, GAContext context) {
        FurnLayoutIndividual newInd = individual.clone();
        int genomeMinLength = 1;
        int genomeMaxLength = 6;
        if (context != null) {
            if (context.containsKey((Object)"GenomeMinLength")) {
                genomeMinLength = (Integer)context.get((Object)"GenomeMinLength");
            }
            if (context.containsKey((Object)"GenomeMaxLength")) {
                genomeMaxLength = (Integer)context.get((Object)"GenomeMaxLength");
            }
        }
        if (this.doOperate(this.pRemoveFurniture) && newInd.getFurnitures().size() > genomeMinLength) {
            newInd.getFurnitures().remove(this.getRandom().nextInt(newInd.getFurnitures().size()));
        }
        for (FurnEntry entry : newInd.getFurnitures()) {
            int translation;
            if (this.doOperate()) {
                entry.setFurniture(FurnitureUtil.getOtherFurnitureBySimilarityDistance(entry.getFurniture(), this.getRandom().nextInt(this.wID) + 1));
            }
            RoomVector vec = entry.getVector();
            if (this.doOperate()) {
                translation = this.getRandom().nextInt(this.wTranslate + 1) - this.wTranslate / 2;
                vec = vec.getTranslatedInstance(translation, 0);
            }
            if (this.doOperate()) {
                translation = this.getRandom().nextInt(this.wTranslate + 1) - this.wTranslate / 2;
                vec = vec.getTranslatedInstance(0, translation);
            }
            if (this.doOperate()) {
                int dRot = this.getRandom().nextInt(this.wRotate);
                if (dRot != 0 && this.getRandom().nextBoolean()) {
                    dRot *= -1;
                }
                vec = vec.getRotatedInstance(dRot);
            }
            entry.setVector(vec);
        }
        if (this.doOperate(this.pNewFurniture) && newInd.getFurnitures().size() < genomeMaxLength) {
            Object o;
            float minX = -10.0f;
            float maxX = 10.0f;
            float minY = -10.0f;
            float maxY = 10.0f;
            IPhenotypeSpace space = null;
            if (context != null && (o = context.get((Object)"ValidationSpace")) != null && o instanceof IPhenotypeSpace) {
                space = (IPhenotypeSpace)o;
                minX = (float)space.getOutterBounds().getX();
                maxX = (float)(space.getOutterBounds().getX() + space.getOutterBounds().getWidth());
                minY = (float)space.getOutterBounds().getY();
                maxY = (float)(space.getOutterBounds().getY() + space.getOutterBounds().getHeight());
            }
            List all = FurnCache.getInstance().getAllFurnitures();
            int x = Math.round((this.getRandom().nextFloat() * (maxX - minX) + minX) * 100.0f);
            int y = Math.round((this.getRandom().nextFloat() * (maxY - minY) + minY) * 100.0f);
            int rotationSteps = this.getRandom().nextInt(4);
            Furniture f = (Furniture)all.get(this.getRandom().nextInt(all.size()));
            newInd.getFurnitures().add(new FurnEntry(new RoomVector(x, y, rotationSteps), f));
        }
        return newInd;
    }

    public static void main(String[] args) {
        GAContext context = new GAContext();
        context.put("ValidationSpace", (Object)new PseudoSpace(10.0f, 10.0f));
        FurnLayoutIndividual ind = new FurnLayoutIndividual(context);
        ind.initRandomly();
        RealMutationOp crossover = new RealMutationOp(100);
        System.out.println("\n BEFORE\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind.getSimpleGenotype()));
        FurnLayoutIndividual newInd = crossover.mutate(ind, context);
        System.out.println("\n AFTER\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(newInd.getSimpleGenotype()));
    }
}

