/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.operators;

import furny.entities.Furniture;
import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.RoomVector;
import furny.ga.util.CollectionUtils;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

public class SegmentCutCrossoverOp
extends ProbabilityOp
implements ICrossoverOp<FurnLayoutIndividual> {
    public SegmentCutCrossoverOp(int pCrossOver) {
        super(pCrossOver);
    }

    public IndividualList<FurnLayoutIndividual> crossover(FurnLayoutIndividual individual1, FurnLayoutIndividual individual2, GAContext context) {
        IndividualList list = new IndividualList();
        FurnLayoutIndividual ind1 = individual1.clone();
        FurnLayoutIndividual ind2 = individual2.clone();
        if (this.doOperate() && !individual1.equals(individual2)) {
            FurnEntryList cIntersection = new FurnEntryList(individual1.getFurnitures());
            cIntersection.retainAll(individual2.getFurnitures());
            FurnEntryList cA = new FurnEntryList(individual1.getFurnitures());
            cA.removeAll(cIntersection);
            FurnEntryList cB = new FurnEntryList(individual2.getFurnitures());
            cB.removeAll(cIntersection);
            CollectionUtils.randomOrder(cA);
            CollectionUtils.randomOrder(cB);
            FurnEntryList bigger = cA.size() >= cB.size() ? cA : cB;
            FurnEntryList smaller = cA.size() < cB.size() ? cA : cB;
            FurnEntryList biggerSource = new FurnEntryList(bigger);
            int lMax = biggerSource.size();
            int r = this.getRandom().nextInt(Math.max(lMax - 1, 1));
            for (int i = 0; i < lMax; ++i) {
                FurnEntry sB;
                FurnEntry sA = (FurnEntry)biggerSource.get(i);
                FurnEntry furnEntry = sB = smaller.size() > i ? (FurnEntry)smaller.get(i) : null;
                if (i <= r) {
                    if (sB == null) continue;
                    if (this.getRandom().nextBoolean()) {
                        Furniture tmp = sA.getFurniture();
                        sA.setFurniture(sB.getFurniture());
                        sB.setFurniture(tmp);
                    }
                    int x1 = sA.getVector().getXGene();
                    int x2 = sB.getVector().getXGene();
                    if (this.getRandom().nextBoolean()) {
                        int tmp = x1;
                        x1 = x2;
                        x2 = tmp;
                    }
                    int y1 = sA.getVector().getYGene();
                    int y2 = sB.getVector().getYGene();
                    if (this.getRandom().nextBoolean()) {
                        int tmp = y1;
                        y1 = y2;
                        y2 = tmp;
                    }
                    int rot1 = sA.getVector().getRotationSteps();
                    int rot2 = sB.getVector().getRotationSteps();
                    if (this.getRandom().nextBoolean()) {
                        int tmp = rot1;
                        rot1 = rot2;
                        rot2 = tmp;
                    }
                    sA.setVector(new RoomVector(x1, y1, rot1));
                    sB.setVector(new RoomVector(x2, y2, rot2));
                    continue;
                }
                if (sB != null) {
                    bigger.set(i, sB);
                    smaller.set(i, sA);
                    continue;
                }
                smaller.add(sA);
                bigger.remove(sA);
            }
            ind1.getFurnitures().clear();
            ind1.getFurnitures().addAll(cIntersection);
            ind1.getFurnitures().addAll(cA);
            ind2.getFurnitures().clear();
            ind2.getFurnitures().addAll(cIntersection);
            ind2.getFurnitures().addAll(cB);
        }
        list.add((Object)ind1);
        list.add((Object)ind2);
        return list;
    }

    public static void main(String[] args) {
        GAContext context = new GAContext();
        context.put("ValidationSpace", (Object)new PseudoSpace(10.0f, 10.0f));
        FurnLayoutIndividual ind1 = new FurnLayoutIndividual(context);
        ind1.initRandomly();
        FurnLayoutIndividual ind2 = new FurnLayoutIndividual(context);
        ind2.initRandomly();
        ind2.getFurnitures().add(ind1.getFurnitures().get(0));
        SegmentCutCrossoverOp crossover = new SegmentCutCrossoverOp(100);
        System.out.println("\n PARENT 1\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind1.getSimpleGenotype()));
        System.out.println("\n PARENT 2\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind2.getSimpleGenotype()));
        IndividualList list = crossover.crossover((IIndividual)ind1, (IIndividual)ind2, context);
        for (int i = 0; i < list.size(); ++i) {
            FurnLayoutIndividual newInd = (FurnLayoutIndividual)list.get(i);
            System.out.println("\n CHILD " + (i + 1) + "\n");
            System.out.println(FurnLayoutIOUtil.printSimpleGenotype(newInd.getSimpleGenotype()));
        }
    }
}

