/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.operators;

import furny.entities.Furniture;
import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

public class SwapCrossoverOp
extends ProbabilityOp
implements ICrossoverOp<FurnLayoutIndividual> {
    public SwapCrossoverOp(int pCrossOver) {
        super(pCrossOver);
    }

    public IndividualList<FurnLayoutIndividual> crossover(FurnLayoutIndividual individual1, FurnLayoutIndividual individual2, GAContext context) {
        IndividualList list = new IndividualList();
        FurnLayoutIndividual ind1 = individual1.clone();
        FurnLayoutIndividual ind2 = individual2.clone();
        if (this.doOperate()) {
            FurnEntryList bigger;
            FurnEntryList smaller;
            if (ind1.getFurnitures().size() < ind2.getFurnitures().size()) {
                smaller = ind1.getFurnitures();
                bigger = ind2.getFurnitures();
            } else {
                smaller = ind2.getFurnitures();
                bigger = ind1.getFurnitures();
            }
            int i = 0;
            while (i++ < bigger.size()) {
                boolean swap = this.getRandom().nextBoolean();
                if (!swap) continue;
                if (i < smaller.size()) {
                    boolean keepPosition = this.getRandom().nextBoolean();
                    if (keepPosition) {
                        FurnEntry entry1 = (FurnEntry)smaller.get(i);
                        FurnEntry entry2 = (FurnEntry)bigger.get(i);
                        Furniture fTemp = entry1.getFurniture();
                        entry1.setFurniture(entry2.getFurniture());
                        entry2.setFurniture(fTemp);
                        continue;
                    }
                    smaller.set(i, bigger.set(i, smaller.get(i)));
                    continue;
                }
                smaller.add(bigger.remove(this.getRandom().nextInt(bigger.size())));
            }
        }
        list.add((Object)ind1);
        list.add((Object)ind2);
        return list;
    }

    public static void main(String[] args) {
        GAContext context = new GAContext();
        context.put("ValidationSpace", (Object)new PseudoSpace(10.0f, 10.0f));
        FurnLayoutIndividual ind1 = new FurnLayoutIndividual(context);
        ind1.initRandomly();
        FurnLayoutIndividual ind2 = new FurnLayoutIndividual(context);
        ind2.initRandomly();
        ind2.getFurnitures().add(ind1.getFurnitures().get(0));
        SwapCrossoverOp crossover = new SwapCrossoverOp(100);
        System.out.println("\n PARENT 1\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind1.getSimpleGenotype()));
        System.out.println("\n PARENT 2\n");
        System.out.println(FurnLayoutIOUtil.printSimpleGenotype(ind2.getSimpleGenotype()));
        IndividualList list = crossover.crossover((IIndividual)ind1, (IIndividual)ind2, context);
        for (int i = 0; i < list.size(); ++i) {
            FurnLayoutIndividual newInd = (FurnLayoutIndividual)list.get(i);
            System.out.println("\n CHILD " + (i + 1) + "\n");
            System.out.println(FurnLayoutIOUtil.printSimpleGenotype(newInd.getSimpleGenotype()));
        }
    }
}

