/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.rules;

import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import ga.core.validation.GAContext;
import ga.core.validation.IValidationRule;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FurnitureIntersectionRule
implements IValidationRule<FurnLayoutIndividual> {
    private static final Logger LOGGER = Logger.getLogger(FurnitureIntersectionRule.class.getName());

    public float matchingDegree(FurnLayoutIndividual individual, GAContext context) {
        FurnEntryList list1 = new FurnEntryList(individual.getFurnitures());
        FurnEntryList list2 = new FurnEntryList(list1);
        while (list1.size() > 0) {
            FurnEntry entry1 = (FurnEntry)list1.remove(0);
            for (FurnEntry entry2 : list2) {
                if (entry1 != entry2 && entry1.getBounds().getBoundingBox().getAsAWTRectangle2D().intersects(entry2.getBounds().getBoundingBox().getAsAWTRectangle2D())) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(individual.getId() + ":  " + entry1 + " intersects " + entry2);
                    }
                    return 0.0f;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(individual.getId() + ":  " + entry1 + " intersects not " + entry2);
            }
        }
        return 1.0f;
    }

    public IValidationRule.Type getType() {
        return IValidationRule.Type.MANDATORY;
    }
}

