/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.rules;

import furny.entities.Tag;
import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import ga.core.validation.GAContext;
import ga.core.validation.IValidationRule;
import ga.view.interfaces.IPhenotypeSpace;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MaxDistanceToWallRule
implements IValidationRule<FurnLayoutIndividual> {
    private static final Logger LOGGER = Logger.getLogger(MaxDistanceToWallRule.class.getName());
    private float maxAllowedDistance = 1.0f;
    private final Tag tag;

    public MaxDistanceToWallRule(String tagName, float maxDistance) {
        this.tag = Tag.valueOf((String)tagName);
        this.maxAllowedDistance = maxDistance;
    }

    public MaxDistanceToWallRule(float maxDistance) {
        this("Location/Wall", maxDistance);
    }

    public float matchingDegree(FurnLayoutIndividual individual, GAContext context) {
        Object o = context.get((Object)"ValidationSpace");
        float maxDistance = 0.0f;
        if (o != null && o instanceof IPhenotypeSpace) {
            IPhenotypeSpace space = (IPhenotypeSpace)o;
            for (FurnEntry entry : individual.getFurnitures()) {
                if (!entry.getFurniture().getMetaData().getTags().contains(this.tag)) continue;
                maxDistance = Math.max(maxDistance, space.minDistanceToWall(entry.getBounds(), entry.getVector().getRotation()));
            }
        } else {
            throw new RuntimeException("Showroom not found in the validation context");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Max Distance: " + maxDistance);
        }
        if (maxDistance == 0.0f) {
            return 1.0f;
        }
        return Math.min(1.0f, this.maxAllowedDistance / maxDistance);
    }

    public IValidationRule.Type getType() {
        return IValidationRule.Type.PROPOSED;
    }
}

