/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.rules;

import furny.entities.Tag;
import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import ga.core.validation.GAContext;
import ga.core.validation.IValidationRule;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MinMaxCountRule
implements IValidationRule<FurnLayoutIndividual> {
    private static final Logger LOGGER = Logger.getLogger(MinMaxCountRule.class.getName());
    private final int minCount;
    private final int maxCount;
    private final Tag tag;

    public MinMaxCountRule(String tagName, int minCount, int maxCount) {
        this.tag = Tag.valueOf((String)tagName);
        this.minCount = minCount;
        this.maxCount = maxCount;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(minCount + " <= n <= " + maxCount);
        }
    }

    public float matchingDegree(FurnLayoutIndividual individual, GAContext context) {
        int i = 0;
        for (FurnEntry entry : individual.getFurnitures()) {
            if (!entry.getFurniture().getMetaData().getTags().contains(this.tag) || ++i <= this.maxCount) continue;
            return 0.0f;
        }
        if (i < this.minCount) {
            return 0.0f;
        }
        return 1.0f;
    }

    public IValidationRule.Type getType() {
        return IValidationRule.Type.PROPOSED;
    }
}

