/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.util;

import com.jme3.math.FastMath;
import furny.entities.Furniture;
import furny.furndb.FurnCache;
import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.RoomVector;
import furny.ga.util.FurnitureUtil;
import ga.core.validation.GAContext;
import ga.view.interfaces.IPhenotypeSpace;
import java.util.List;

public final class Distance {
    private Distance() {
    }

    @Deprecated
    public static float calcDistance(FurnLayoutIndividual ind1, FurnLayoutIndividual ind2, GAContext context) {
        FurnEntryList list1 = ind1.getFurnitures();
        FurnEntryList list2 = ind2.getFurnitures();
        float dist = 0.0f;
        for (FurnEntry e1 : list1) {
            for (FurnEntry e2 : list2) {
                double d = Distance.furnEntryDistance(e1, e2, context);
                dist = (float)((double)dist + d);
            }
        }
        return dist / (float)(list1.size() * list2.size());
    }

    public static float calcDistance2(FurnLayoutIndividual ind1, FurnLayoutIndividual ind2, GAContext context) {
        FurnEntryList list1 = ind1.getFurnitures();
        FurnEntryList list2 = ind2.getFurnitures();
        float d1 = Distance.leftFurnEntryDistance(list1, list2, context);
        float d2 = Distance.leftFurnEntryDistance(list2, list1, context);
        float dist = (d1 + d2) / 2.0f;
        return dist;
    }

    private static float leftFurnEntryDistance(FurnEntryList l1, FurnEntryList l2, GAContext context) {
        if (l1.isEmpty() && l2.isEmpty()) {
            return 0.0f;
        }
        if (l1.isEmpty() != l2.isEmpty()) {
            return 1.0f;
        }
        float dist = 0.0f;
        for (FurnEntry fe : l1) {
            FurnEntryList list = l2.getEntries(fe.getFurniture());
            if (!list.isEmpty()) {
                dist += Distance.lowestFurnEntryDistance(fe, list, context);
                continue;
            }
            dist += Distance.lowestFurnEntryDistance(fe, l2, context);
        }
        return dist / (float)l1.size();
    }

    private static float lowestFurnEntryDistance(FurnEntry entry, FurnEntryList others, GAContext context) {
        float dist = 1.0f;
        for (FurnEntry fe : others) {
            float dTemp = Distance.furnEntryDistance(entry, fe, context);
            if (!(dTemp < dist)) continue;
            dist = dTemp;
        }
        return dist;
    }

    private static float furnEntryDistance(FurnEntry e1, FurnEntry e2, GAContext context) {
        Object o = context.get((Object)"ValidationSpace");
        if (o != null && o instanceof IPhenotypeSpace) {
            float wID = context.getFloat("wID", 8.0f).floatValue();
            float wTrans = context.getFloat("wTrans", 2.0f).floatValue();
            float wRot = context.getFloat("wRot", 1.0f).floatValue();
            float dist = 0.0f;
            IPhenotypeSpace space = (IPhenotypeSpace)o;
            float roomWidth = (float)space.getOutterBounds().getWidth();
            float roomLength = (float)space.getOutterBounds().getHeight();
            dist += e1.getVector().distance(e2.getVector()) / FastMath.sqrt((float)(FastMath.pow((float)roomWidth, (float)2.0f) + FastMath.pow((float)roomLength, (float)2.0f))) * wTrans;
            dist = (float)((double)dist + (double)FastMath.abs((float)e1.getVector().diffRotation(e2.getVector())) / 2.0 * (double)wRot);
            if (!e1.getFurniture().equals((Object)e2.getFurniture())) {
                double sim = FurnitureUtil.getSimilarity(e1.getFurniture(), e2.getFurniture());
                dist = (float)((double)dist + (1.0 - sim) * (double)wID);
            }
            return dist / (wID + wTrans + wRot);
        }
        throw new RuntimeException("Phenotype space not found in the ga context");
    }

    public static void main(String[] args) {
        GAContext context = new GAContext();
        context.put("ValidationSpace", (Object)new PseudoSpace(10.0f, 10.0f));
        context.put("wID", (Object)8);
        context.put("wTrans", (Object)2);
        context.put("wRot", (Object)1);
        FurnLayoutIndividual ind1 = new FurnLayoutIndividual(context);
        List all = FurnCache.getInstance().getAllFurnitures();
        ind1.getFurnitures().add(new FurnEntry(new RoomVector(-500, -500, 1), (Furniture)all.get(1)));
        ind1.getFurnitures().add(new FurnEntry(new RoomVector(50, 50, 1), (Furniture)all.get(0)));
        FurnLayoutIndividual ind2 = new FurnLayoutIndividual(context);
        ind2.getFurnitures().add(new FurnEntry(new RoomVector(500, 500, 3), (Furniture)all.get(1)));
        ind2.getFurnitures().add(new FurnEntry(new RoomVector(100, 150, 2), (Furniture)all.get(1)));
        ind2.getFurnitures().add(new FurnEntry(new RoomVector(100, 100, 2), (Furniture)all.get(0)));
        System.err.println(ind1);
        System.err.println(ind2);
        System.err.println("Failers");
        System.err.println(Distance.calcDistance(ind1, ind2, context));
        System.err.println(Distance.calcDistance(ind2, ind1, context));
        System.err.println(Distance.calcDistance(ind1, ind1, context));
        System.err.println();
        System.err.println("New calculation");
        System.err.println(Distance.calcDistance2(ind1, ind2, context));
        System.err.println(Distance.calcDistance2(ind2, ind1, context));
        System.err.println(Distance.calcDistance2(ind1, ind1, context));
    }
}

