/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.util;

import furny.entities.Furniture;
import furny.furndb.FurnDBManager;
import furny.ga.FurnEntry;
import furny.ga.FurnEntryList;
import furny.ga.FurnLayoutIndividual;
import furny.ga.RoomVector;
import furny.ga.util.ExtensionFileFilter;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public final class FurnLayoutIOUtil {
    private static final Logger LOGGER = Logger.getLogger(FurnLayoutIOUtil.class.getName());
    private static File lastDir = new File(".");

    private FurnLayoutIOUtil() {
    }

    public static String printSimpleGenotype(long[][] store) {
        StringBuilder sb = new StringBuilder();
        FurnLayoutIOUtil.writeSimpleGenotypeHeader(sb);
        FurnLayoutIOUtil.writeSimpleGenotype(store, sb);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(sb.toString());
        }
        return sb.toString();
    }

    public static String printGenotypes(List<FurnLayoutIndividual> list) {
        StringBuilder sb = new StringBuilder();
        for (FurnLayoutIndividual ind : list) {
            sb.append(ind.getId());
            sb.append(": ");
            FurnLayoutIOUtil.writeSimpleGenotype(ind.getSimpleGenotype(), sb);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(sb.toString());
        }
        return sb.toString();
    }

    public static FurnLayoutIndividual parseIndividual(String string) {
        FurnLayoutIndividual ind = new FurnLayoutIndividual();
        if (FurnLayoutIOUtil.parse(ind, string)) {
            return ind;
        }
        throw new RuntimeException("Error parsing individual");
    }

    public static boolean parse(FurnLayoutIndividual ind, String string) {
        if (ind == null) {
            LOGGER.severe("No Individual given");
            return false;
        }
        FurnEntryList newGenes = new FurnEntryList();
        Pattern regex = Pattern.compile("\\{(.*?)\\}", 32);
        Matcher matcher = regex.matcher(string.replaceAll(" ", ""));
        Pattern regex2 = Pattern.compile("\\(([^,]+),([^,]+),([^,]+),([^\\)]+)");
        if (matcher.find()) {
            String genotype = matcher.group(1);
            Matcher matcher2 = regex2.matcher(genotype);
            while (matcher2.find()) {
                try {
                    long id = Integer.valueOf(matcher2.group(1)).intValue();
                    int x = Integer.valueOf(matcher2.group(2));
                    int y = Integer.valueOf(matcher2.group(3));
                    int rotationSteps = Integer.valueOf(matcher2.group(4));
                    Furniture f = FurnDBManager.getInstance().getFurniture(Long.valueOf(id));
                    if (f == null) {
                        throw new Exception("No furniture for id " + id);
                    }
                    FurnEntry entry = new FurnEntry(new RoomVector(x, y, rotationSteps), f);
                    newGenes.add(entry);
                }
                catch (Exception e) {
                    LOGGER.warning(e.toString());
                    return false;
                }
            }
        }
        ind.getFurnitures().clear();
        ind.getFurnitures().addAll(newGenes);
        return true;
    }

    public static void writeSimpleGenotypeHeader(StringBuilder sb) {
        sb.append("FurnID;x;y;rotation\n");
    }

    public static void writeSimpleGenotype(long[][] store, StringBuilder sb) {
        for (int i = 0; i < store.length; ++i) {
            sb.append(store[i][0]);
            sb.append(';');
            sb.append(store[i][1]);
            sb.append(';');
            sb.append(store[i][2]);
            sb.append(';');
            sb.append(store[i][3]);
            sb.append('\n');
        }
    }

    public static void writeSimpleGenotypeSet(long[][] store, StringBuilder sb) {
        sb.append('{');
        boolean first = true;
        for (int i = 0; i < store.length; ++i) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append('(');
            sb.append(store[i][0]);
            sb.append(',');
            sb.append(store[i][1]);
            sb.append(',');
            sb.append(store[i][2]);
            sb.append(',');
            sb.append(store[i][3]);
            sb.append(')');
        }
        sb.append('}');
    }

    public static void writeFitness(FurnLayoutIndividual ind, StringBuilder sb) {
        sb.append("Fitness: ");
        if (ind.isEvaluated()) {
            sb.append(ind.getFitness());
        } else {
            sb.append("unevaluated");
        }
        sb.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FurnLayoutIndividual loadGenotype(Component parent, FurnLayoutIndividual ind) {
        File f;
        FurnLayoutIndividual fli = ind != null ? ind : new FurnLayoutIndividual();
        JFileChooser fc = new JFileChooser(lastDir);
        fc.setFileFilter(new ExtensionFileFilter("Furny individuals (*.fi)", "fi"));
        int n = fc.showOpenDialog(parent);
        if (n == 0 && (f = fc.getSelectedFile()) != null) {
            lastDir = fc.getCurrentDirectory();
            BufferedReader fr = null;
            try {
                fr = new BufferedReader(new FileReader(f));
                String content = fr.readLine();
                if (FurnLayoutIOUtil.parse(fli, content)) {
                    FurnLayoutIndividual furnLayoutIndividual = fli;
                    return furnLayoutIndividual;
                }
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(parent, e1.toString(), "Error writing file", 2);
                LOGGER.log(Level.WARNING, "Error loading file", e1);
            }
            finally {
                try {
                    fr.close();
                }
                catch (Exception e2) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveGenotype(Component parent, FurnLayoutIndividual ind) {
        boolean ok = true;
        do {
            JFileChooser fc = new JFileChooser(lastDir);
            fc.setFileFilter(new ExtensionFileFilter("Furny individuals (*.fi)", "fi"));
            int n = fc.showSaveDialog(parent);
            if (n == 0) {
                File f = fc.getSelectedFile();
                if (f == null) continue;
                lastDir = fc.getCurrentDirectory();
                if (!f.getName().endsWith(".fi")) {
                    f = new File(f.getAbsolutePath() + ".fi");
                }
                if (f.exists()) {
                    int ync = JOptionPane.showConfirmDialog(parent, "File already exists. Do you want to overwrite?", "File exists", 1);
                    switch (ync) {
                        case 0: {
                            ok = true;
                            break;
                        }
                        case 1: {
                            ok = false;
                            break;
                        }
                        default: {
                            return 2;
                        }
                    }
                }
                if (!ok) continue;
                BufferedWriter fw = null;
                try {
                    fw = new BufferedWriter(new FileWriter(f));
                    fw.write(ind.getGenotypeString());
                    JOptionPane.showMessageDialog(parent, "Individual successfully saved", "Success", 1);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(parent, e1.toString(), "Error writing file", 2);
                    LOGGER.log(Level.WARNING, "Error writing file", e1);
                    ok = false;
                }
                finally {
                    try {
                        fw.close();
                    }
                    catch (Exception e2) {}
                }
            }
            return 2;
        } while (!ok);
        return 0;
    }
}

