/*
 * Decompiled with CFR 0.152.
 */
package furny.ga.util;

import furny.entities.Furniture;
import furny.entities.Tag;
import furny.furndb.FurnCache;
import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import ga.core.algorithm.util.RandomSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ObjectUtils;

public final class FurnitureUtil {
    private static final Logger LOGGER = Logger.getLogger(FurnitureUtil.class.getName());
    private static final Map<FurniturePair, Double> SIMILARITY_MAP = new HashMap<FurniturePair, Double>();

    private FurnitureUtil() {
    }

    public static double getSimilarity(Furniture furn1, Furniture furn2) {
        if (furn1.equals((Object)furn2)) {
            return 1.0;
        }
        FurniturePair key = new FurniturePair(furn1, furn2);
        Double d = SIMILARITY_MAP.get(key);
        if (d == null) {
            d = FurnitureUtil.getSimilarityImpl(furn1, furn2);
            SIMILARITY_MAP.put(key, d);
        }
        return d;
    }

    private static double getSimilarityImpl(Furniture furn1, Furniture furn2) {
        double dScal = 1.0 - FurnitureUtil.getManhattanDistance(furn1.getMetaData().getWidth().floatValue(), furn2.getMetaData().getWidth().floatValue(), furn1.getMetaData().getLength().floatValue(), furn2.getMetaData().getLength().floatValue());
        double dTag = FurnitureUtil.getTagSimilarity(furn1, furn2);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("similarity scal " + dScal);
            LOGGER.fine("similarity tag " + dTag);
            LOGGER.fine("similarity total " + (dScal + dTag) / 2.0);
        }
        return (dScal + dTag) / 2.0;
    }

    private static double getManhattanDistance(double w1, double w2, double l1, double l2) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(w1 + ", " + w2 + ", " + l1 + ", " + l2 + ",");
        }
        return (Math.abs(w1 - w2) + Math.abs(l1 - l2)) / (Math.max(w1, w2) + Math.max(l1, l2));
    }

    private static double getTagSimilarity(Furniture furn1, Furniture furn2) {
        Set tags1 = furn1.getMetaData().getTags();
        Set tags2 = furn2.getMetaData().getTags();
        double ranking1 = 0.0;
        double ranking2 = 0.0;
        double matches = 0.0;
        for (Tag t1 : tags1) {
            ranking1 += (double)t1.getType().getRanking();
            if (!tags2.contains(t1)) continue;
            matches += (double)t1.getType().getRanking();
        }
        for (Tag t2 : tags2) {
            ranking2 += (double)t2.getType().getRanking();
        }
        if (ranking1 > 0.0 || ranking1 > 0.0) {
            return matches / Math.max(ranking1, ranking2);
        }
        return 0.0;
    }

    public static Map<Furniture, Double> getSimilarityRankMap(Furniture furn1, List<Furniture> allFurnitures) {
        HashMap<Furniture, Double> all = new HashMap<Furniture, Double>();
        for (Furniture f : allFurnitures) {
            all.put(f, FurnitureUtil.getSimilarity(furn1, f));
        }
        return FurnitureUtil.createSortedMap(all);
    }

    private static <T extends Comparable<T>> Map<Furniture, T> createSortedMap(Map<Furniture, T> passedMap) {
        ArrayList<T> mapValues = new ArrayList<T>(passedMap.values());
        Collections.sort(mapValues, Collections.reverseOrder());
        LinkedHashMap<Furniture, Comparable> sortedMap = new LinkedHashMap<Furniture, Comparable>();
        for (Comparable value : mapValues) {
            for (Map.Entry<Furniture, T> entry : passedMap.entrySet()) {
                if (entry.getValue() != value) continue;
                sortedMap.put(entry.getKey(), value);
            }
        }
        return sortedMap;
    }

    public static Furniture getOtherFurnitureBySimilarityRoulette(Furniture f1) {
        return FurnitureUtil.rouletteImpl(FurnitureUtil.getSimilarityRankMap(f1, FurnCache.getInstance().getAllFurnitures()));
    }

    public static Furniture getOtherFurnitureBySimilarityDistance(Furniture f1, int dist) {
        final Map<Furniture, Double> map = FurnitureUtil.getSimilarityRankMap(f1, FurnCache.getInstance().getAllFurnitures());
        ArrayList<Furniture> list = new ArrayList<Furniture>(map.keySet());
        Collections.sort(list, new Comparator<Furniture>(){

            @Override
            public int compare(Furniture o1, Furniture o2) {
                double n2;
                double n1 = (Double)map.get(o1);
                if (n1 < (n2 = ((Double)map.get(o2)).doubleValue())) {
                    return 1;
                }
                if (n1 > n2) {
                    return -1;
                }
                return 0;
            }
        });
        return (Furniture)list.get(Math.min(dist, list.size() - 1));
    }

    private static Furniture rouletteImpl(Map<Furniture, Double> map) {
        int idx;
        Furniture[] furns = new Furniture[map.size()];
        double totalValue = 0.0;
        int i = 0;
        for (Map.Entry<Furniture, Double> entry : map.entrySet()) {
            furns[i++] = entry.getKey();
            totalValue += entry.getValue().doubleValue();
        }
        double randNum = RandomSingleton.getRandom().nextDouble() * totalValue;
        for (idx = 0; idx < furns.length && randNum > 0.0; randNum -= map.get(furns[idx]).doubleValue(), ++idx) {
        }
        return furns[idx - 1];
    }

    public static float getCosts(FurnLayoutIndividual ind) {
        double costs = 0.0;
        for (FurnEntry entry : ind.getFurnitures()) {
            costs += entry.getFurniture().getMetaData().getPrice().doubleValue();
        }
        return (float)costs;
    }

    public static void main(String[] args) {
        Furniture f1 = (Furniture)FurnCache.getInstance().getAllFurnitures().get(0);
        Furniture f2 = (Furniture)FurnCache.getInstance().getAllFurnitures().get(1);
        System.out.println(f1.getName());
        System.out.println(f2.getName());
        System.out.println(FurnitureUtil.getSimilarity(f1, f2));
        System.out.println(FurnitureUtil.getSimilarity(f2, f1));
        System.out.println(FurnitureUtil.getSimilarity(f1, f2));
        System.out.println(FurnitureUtil.getSimilarity(f2, f2));
        System.out.println(FurnitureUtil.getSimilarity(f1, f1));
    }

    private static class FurniturePair {
        private final Furniture smaller;
        private final Furniture bigger;

        public FurniturePair(Furniture f1, Furniture f2) {
            this.smaller = f1.getId() < f2.getId() ? f1 : f2;
            this.bigger = this.smaller == f1 ? f2 : f1;
        }

        public int hashCode() {
            return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.smaller, this.bigger});
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && ((FurniturePair)obj).smaller.equals((Object)this.smaller) && ((FurniturePair)obj).bigger.equals((Object)this.bigger);
        }
    }
}

