/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.tools.SizeValue;

public class TextSize
implements EffectImpl {
    private float startSize;
    private float endSize;
    private SizeValue textSize = new SizeValue("100%");

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.startSize = Float.parseFloat(parameter.getProperty("startSize", "1.0"));
        this.endSize = Float.parseFloat(parameter.getProperty("endSize", "2.0"));
        String maxSizeString = parameter.getProperty("maxSize");
        if (maxSizeString != null) {
            this.textSize = new SizeValue(maxSizeString);
        }
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        float scale;
        if (falloff == null) {
            float t = normalizedTime;
            scale = this.startSize + t * (this.endSize - this.startSize);
        } else {
            scale = 1.0f + falloff.getFalloffValue() * this.textSize.getValue(1.0f);
        }
        r.setRenderTextSize(scale);
        TextRenderer textRenderer = element.getRenderer(TextRenderer.class);
        if (textRenderer != null) {
            String text = textRenderer.getWrappedText();
            RenderFont font = textRenderer.getFont();
            float originalWidth = font.getWidth(text, 1.0f);
            float sizedWidth = font.getWidth(text, scale);
            float originalHeight = font.getHeight();
            float sizedHeight = (float)font.getHeight() * scale;
            r.moveTo(-(sizedWidth - originalWidth) / 2.0f, -(sizedHeight - originalHeight) / 2.0f);
        }
    }

    @Override
    public void deactivate() {
    }
}

