#include <cassert>
#include "AksenIO.h"


AksenIO::AksenIO()
{
	this->mCOM = NULL;
}


bool AksenIO::Open()
{
	HRESULT hr = CoInitialize(NULL);
    if(FAILED(hr)) return false;

	this->mCOM = CreateFile("COM2", GENERIC_WRITE | GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if(this->mCOM == INVALID_HANDLE_VALUE) return false;
	DCB dcb;	
	ZeroMemory(&dcb, sizeof(DCB));
    dcb.BaudRate = 9600;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	dcb.fDtrControl = DTR_CONTROL_ENABLE;
	dcb.fRtsControl = RTS_CONTROL_ENABLE;
	if(!SetCommState(this->mCOM, &dcb)) return false;

	if(!SetCommMask(this->mCOM, EV_RXCHAR)) return false;

    PurgeComm(this->mCOM, PURGE_TXCLEAR);
    PurgeComm(this->mCOM, PURGE_RXCLEAR);

	COMMTIMEOUTS timeout;
	ZeroMemory(&timeout, sizeof(COMMTIMEOUTS));
	timeout.ReadIntervalTimeout = MAXDWORD;
	timeout.ReadTotalTimeoutMultiplier = MAXDWORD;
	timeout.ReadTotalTimeoutConstant = 1000; // one second timeout
	timeout.WriteTotalTimeoutMultiplier = MAXDWORD;
	timeout.WriteTotalTimeoutConstant = 1000;
	if (!SetCommTimeouts(this->mCOM, &timeout)) return false;

	ZeroMemory(&this->mOverlapped, sizeof(OVERLAPPED));
	this->mOverlapped.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
    
	return true;
}



void AksenIO::Close()
{
	assert(this->mCOM);
    CloseHandle(this->mCOM);
}



bool AksenIO::Send(const char* string, unsigned long length, unsigned long* count)
{
	if(!this->mCOM) return false;


	if(!WriteFile(this->mCOM, string, length, count, &this->mOverlapped))
	{

		if (GetLastError() != ERROR_IO_PENDING)
		{
			return false;
		}
		else
		{
			// Write is pending.
			BOOL dwRes = WaitForSingleObject(this->mOverlapped.hEvent, INFINITE);
			switch(dwRes)
			{
				// Overlapped event has been signaled.
				case WAIT_OBJECT_0:
					if (!GetOverlappedResult(this->mCOM, &this->mOverlapped, count, FALSE))
					{
						return false;
					}
					else
					{
						if (length != *count)
						{
							return false;
						}
						else
						{
							// Write operation completed successfully.
							return true;						
						}

					}
					break;

				default:
					// An error has occurred in WaitForSingleObject. This usually
					// indicates a problem with the overlapped event handle.
					return false;
			}
		}
	}
	else
	{
		// WriteFile completed immediately.
		if(*count != length)
		{
			return true;
		}
	}
	
	return true;
}


bool AksenIO::Recieve(char* string, unsigned long length, unsigned long* count)
{
	if(!this->mCOM) return false;
	
	COMSTAT		comState;
	DWORD		dwEvtMask;
	DWORD		dwError		= 0;
	
	WaitCommEvent(this->mCOM, &dwEvtMask, &this->mOverlapped);
	ClearCommError(this->mCOM, &dwError, &comState);

	BOOL dwRes = WaitForSingleObject(this->mOverlapped.hEvent, 1000);
	switch(dwRes)
	{
		case WAIT_OBJECT_0:
			if(!(dwEvtMask & EV_RXCHAR)) return false;
			if(!ReadFile(this->mCOM, string, length, count, &this->mOverlapped)) return false;
			break;

		default:
			return false;
	
	}
	return true;
}
