#include <iostream>
#include <vector>
#include <cassert>
#include <windows.h>
#include <cmath>
#include <winbase.h>
#include "ElfeEvaluator.h"


ElfeEvaluator::ElfeEvaluator()
{
	this->evaluationTime = 15; // seconds
}


bool ElfeEvaluator::startUp()
{
    if(!this->mouseInput.Open()) return false;
	if(!this->aksenIO.Open()) return false;
    return true;
}


void ElfeEvaluator::shutDown()
{
    this->mouseInput.Close();
	this->aksenIO.Close();
}


bool ElfeEvaluator::startEvaluation(Individual* population, unsigned int pop_length)
{
	char c;
	char buffer[256];
	unsigned long count;
	bool skip = false;
	
	int currentXMovement = 0;
	int currentYMovement = 0;
	double currentElapsedTime = 0.0;
	float fitness = 0.0f;

	for(unsigned int p = 0; p < pop_length; p++)
    {    
		skip = false;

		// send syn
		c = 's';
		if(!this->aksenIO.Send(&c, 1, &count)) return false;
		std::cout << "s ";

		// handshaking
		while(1)
		{			
			// recieve ack
			c = 0;
			if(this->aksenIO.Recieve(&buffer[0], 5, &count)) 
			{
				if(count>1) c = buffer[count-1];
				else c = buffer[0];
				std::cout << c << " ";
				if(c == 'a') break;
				if(c == 'n') {
					// send syn
					c = 's';
					if(!this->aksenIO.Send(&c, 1, &count)) return false;
					std::cout << "s ";
				}
			}
		}


		// sending commands
        for(unsigned int i = 0; i<population[p].getLength(); i++)
        {
			sprintf(buffer, "%d,%d,%d,", population[p].cmds[i].servo_nr, population[p].cmds[i].grad, population[p].cmds[i].sleep);			
			if(this->aksenIO.Send(buffer, strlen(buffer), &count))
			{
				//std::cout << (int) population[p].cmds[i].servo_nr << " " << (int) population[p].cmds[i].grad << " " << (int) population[p].cmds[i].sleep << " ";
			}			
			else
			{
				std::cout << std::endl;
				std::cout << "Error: Sending cmd failed!" << std::endl;
				return false;
			}
				
			// recieve ack
			while(1)
			{		
				c = 0;
				if(this->aksenIO.Recieve(&c, 1, &count)) 
				{
					std::cout << c << " ";
					if(c == 'a')
					{
						break;
					}
					else if(c == 'n')
					{
						std::cout << std::endl;
						std::cout << "Warning: Skipping invalid individual!" << std::endl;
						skip = true;
						break;
					}
					else
					{
						std::cout << std::endl;
						std::cout << "Error: Expected Ack!" << std::endl;
						skip = true;
						break;
					}
				}
				std::cout << "lese";
			}

			if(skip) break;
		}
		
		if(!skip)
		{
			std::cout << "f ";
			// send fin
			c = 'f';
			if(!this->aksenIO.Send(&c, 1, &count)) return false;
			
			// recieve count
			while(1)
			{
				c = 0;
				if(this->aksenIO.Recieve(&c, 1, &count))
				{
					std::cout << (int) c << " ";
					if(c != population[p].getLength())
					{
						std::cout << std::endl << "Error: Wrong Cmd Count!" << std::endl;
						return false;
					}
					else
					{
						std::cout << std::endl << "Info: Send to Aksen." << std::endl;
						break;
					}
				}
			}


			// send ack
			std::cout << "a ";
			c = 'a';
			if(!this->aksenIO.Send(&c, 1, &count)) return false;

			// detect mouse movement
			this->DetectMouseMovement(currentXMovement, currentYMovement, currentElapsedTime);

			// calc fitness
			fitness = this->CalcFitness(currentXMovement, currentYMovement, currentElapsedTime);
		}
		else
		{
			// invalid individual
			fitness = 0;

		}

		// set fitness
		population[p].setFitness(fitness); 
		population[p].setTime(currentElapsedTime); 
		std::cout << "Info: fitness: " << fitness << std::endl;
		std::cout << std::endl;
	}

	return true;
}


void ElfeEvaluator::DetectMouseMovement(int& xMovement, int& yMovement, double &elapsedTime)
{
	//MSG msg;
	time_t start;
	time_t current;

	xMovement = 0;
	yMovement = 0;
	time(&start);

	this->mouseInput.SetListener( GetCurrentThreadId() );
	while(this->mouseInput.StartUp() == false);

	while(1)
	{
		bool aksenFinished = false;

		/*
		while(PeekMessage(&msg, (HWND) -1, WM_USER, WM_USER+1, PM_REMOVE) && msg.message == MOUSE_MSG)
		{
			long x = msg.wParam;
			long y = msg.lParam;					
			xMovement += x;
			yMovement += y;
			//std::cout << "|";
			std::cout << "(" << (int) x << ":" << (int) y << ") ";			
			//Sleep(10);
			
			// look for ack for stopping evaluation
			char c = 0;
			unsigned long count = 0;
			aksenFinished = (this->aksenIO.Recieve(&c, 1, &count) && c=='f');
		}*/

		// look for ack for stopping evaluation
		char c = 0;
		unsigned long count = 0;
		if((this->aksenIO.Recieve(&c, 1, &count) && c=='f') || aksenFinished)
		{
			std::cout << "Info: Aksen finished." << std::endl;
			break;
		}
	
		// look for the time for stopping evaluation
		time(&current);
		if(difftime(current, start) > this->evaluationTime)
		{
			std::cout << "Warning: Aksen timeout." << std::endl;
			break;
		}
	}

	time(&current);
	elapsedTime = difftime(current, start);

	Sleep(500);

	xMovement = this->mouseInput.GetXMovement();
	yMovement = this->mouseInput.GetYMovement();

	std::cout << "x:" << (int) xMovement << " y:" << (int) yMovement << " t:" <<  (int) elapsedTime << std::endl ;			

	this->mouseInput.ShutDown();
}


float ElfeEvaluator::CalcFitness(int xMovement, int yMovement, double time)
{
	double fitness = 0;
	if(xMovement==0) xMovement=1;
	if(time==0.0) time=1.0;
	double dxMovement = (double) xMovement;
	double dyMovement = (double) yMovement;

	fitness = ( dyMovement / betrag(dxMovement) * sqrt( dxMovement*dxMovement + dyMovement*dyMovement) + 15 * dyMovement - 15 * betrag(dxMovement) ) / time;
	fitness += 500;
	fitness *= 0.01;
	return (fitness > 0) ? fitness : 0.0f;
	
}


double ElfeEvaluator::betrag(double wert){
	return (wert>0) ? wert:(-wert);
}