#ifndef _ELFE_EVALUATOR_H_
#define _ELFE_EVALUATOR_H_

#include "Evaluator.h"
#include "MouseInput.h"
#include "AksenIO.h"


class ElfeEvaluator: public Evaluator
{
	public:
		ElfeEvaluator();
		virtual bool startUp();
		virtual void shutDown();
		virtual bool startEvaluation(Individual* population, unsigned int pop_length);
	

	private:
		void DetectMouseMovement(int& xMovement, int& yMovement, double &elapsedTime);
		float CalcFitness(int xMovement, int yMovement, double time);
		double betrag(double wert);

		MouseInput mouseInput;
		AksenIO	aksenIO;
		unsigned int evaluationTime;
};

#endif