#include <stdlib.h>
#include <search.h>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <iostream>
#include "GAGenerator.h"
#include "eaux.h"

GAGenerator::GAGenerator(){
	population = NULL;
	iteration = 0;
	mutate_rate = 0.25;
}


GAGenerator::~GAGenerator(){
    this->deletePopulation();
}


Individual* GAGenerator::getPopulation(){
    if(this->population){
		printf("Do evolution\n");
        this->doEvolution();
    }
    else{
		printf("CreateInitialPopulation\n");
        this->createInitialPopulation();
    }

	return this->population;
}


void GAGenerator::reset(void){
	this->iteration = 0;
	this->deletePopulation();
}


void GAGenerator::deletePopulation(void){
    if(this->population){
        delete[] this->population;
        this->population = NULL;
    }
}


void GAGenerator::createInitialPopulation(void){
    this->population = new Individual[POPULATION_SIZE];
	this->iteration++;
}

void GAGenerator::doEvolution(void){
	printf("\nIteration Nr.: %i\n\n", this->iteration);
	// <ind_count> = Anzahl der Eltern = Anzahl der Kinder
	// Muss gerade sein!
	int ind_count = 12;
	// Eltern und Kinder
	Individual **parents = new Individual*[ind_count],
			   **kids = new Individual*[ind_count];

	// <group_size> = Anzahl der Individuen, aus denen Eltern bzw. Kinder
	// ausgewhlt werden
	int group_size = POPULATION_SIZE/4;

	// Gruppe aus zufllig ausgewhlten Individuen.
	// Aus dieser Gruppe werden Eltern und Kinder ausgewhlt
	Individual **group = new Individual*[group_size];
	
	// Bilde die Gruppe aus zufllig ausgewhlten Individuen
	random_group(group, group_size);
	print(group, group_size, "Random Group"); 

	// Selektiere Eltern nach dem Tournament-Prinzip
	tournamentSelection(group, group_size, parents, ind_count, true);
	print(parents, ind_count, "Parents"); 

	// Selektiere Kinder nach dem Tournament-Prinzip
	tournamentSelection(group, group_size, kids, ind_count, false);
	print(kids, ind_count, "Kids");

	// Eltern erzeugen die Kinder
	crossover(parents, kids, ind_count);
	print(kids, ind_count, "New Kids from crossed Parents");
	
	// Individuen mutieren
	mutate();

	unsigned fitness_sum = 0;
	for ( int i = 0 ; i < POPULATION_SIZE ; i++ )
		fitness_sum += population[i].getFitness();
	printf("\nFitness of all Individuals: %u\n", fitness_sum);

    this->iteration++;
}

void GAGenerator::random_group(Individual** group, int size){
	for ( int j = 0 ; j < size ; j++ ){
		group[j] = &population[rand()%POPULATION_SIZE];
	}
}

#define	VALUE	262144 // 2^18

void GAGenerator::tournamentSelection(Individual** group, int size, 
									  Individual** winners, int w_count, bool parents)
{
	unsigned fitness_sum = 0, inv_fitness_sum = 0;
	bool winner_found = false;
	int j;
	for ( j = 0 ; j < size ; j++ )
		fitness_sum += group[j]->getFitness();

	
	if ( parents == false ){
		// Invertieren der Fitnesswerte
		for ( j = 0 ; j < size ; j++ ){
			if ( group[j]->getFitness() == 0 )
				group[j]->m_invFitness = VALUE;
			else
				group[j]->m_invFitness = VALUE/group[j]->getFitness();
		}
		// Bilden der <inv_fitness_sum>
		for ( j = 0 ; j < size ; j++ )
			inv_fitness_sum += group[j]->m_invFitness;
	}
	
	unsigned r, tmp;
	for ( j = 0 ; j < w_count ; j++ ){
		// Innerhalb der Fitnesssumme bleiben
		if ( parents == true )
			r = (unsigned)rand()%fitness_sum;
		else // die invertierten FitnessWerte nehmen
			r = (unsigned)rand()%inv_fitness_sum;
		tmp = 0;
		winner_found = false;
		for ( int i = 0 ; i < size && !winner_found ; i++ ){
			if ( parents == true )
				tmp += group[i]->getFitness();
			else
				tmp += group[i]->m_invFitness;
			if ( r < tmp ){
				winners[j] = group[i];
				winner_found = true;
			}
		}
	}
}

void GAGenerator::crossover(Individual** parents,
							Individual** kids, unsigned ind_count)
{
	if ( (ind_count & 0x00000001) == 1 ){
		printf("\n\nParents- und Kidsanzahl muss gerade sein!\n");
		printf("Korrigiere <ind_count> in \"void GAGenerator::doEvolution(void)\"\n\n");
		exit(0);
	}

	CmdVector cmd_i1, cmd_i2;
	int len1, len2, i;
	for ( int ic = 0 ; ic < ind_count ; ic += 2 ){
		cmd_i1.clear();
		cmd_i2.clear();
		// Lnge von Parent_1
		len1 = parents[ic]->cmds.size();
		// Lnge von Parent_2
		len2 = parents[ic+1]->cmds.size();
		// Anfang von kid1
		for ( i = 0 ; i < len1/2 ; i++ )
			cmd_i1.push_back(parents[ic]->cmds[i]);
		// Anfang von kid2
		for ( i = 0 ; i < len2/2 ; i++ )
			cmd_i2.push_back(parents[ic+1]->cmds[i]);
		// Ende von kid1
		for ( i = len2/2 ; i < len2 ; i++ )
			cmd_i1.push_back(parents[ic+1]->cmds[i]);
		// Ende vom kid2
		for ( i = len1/2 ; i < len1 ; i++ )
			cmd_i2.push_back(parents[ic]->cmds[i]);
		// Die Kinder rekreieren
		kids[ic]->recreate(cmd_i1, cmd_i1.size());
		kids[ic+1]->recreate(cmd_i2, cmd_i2.size());
	}
}

void GAGenerator::mutate(){
	unsigned count = (float)POPULATION_SIZE*mutate_rate;
	Individual* ind;
	for ( int j = 0 ; j < count ; j++ ){
		// Whle Individuum per Zufall
		ind = &population[rand()%POPULATION_SIZE];
		// IndividuumLnge
		int len = ind->cmds.size();
		// Alle Befehle im Individuum mutieren
		for ( int i = 0 ; i < len ; i++ ){
			switch (rand()%3){
				// ServoNr mutiert
				case 0:
				{
					unsigned char mask = 0x01;
					mask <<= rand()%8;
					ind->cmds[i].servo_nr ^= mask;
					ind->cmds[i].servo_nr %= SERVO_COUNT;
					break;
				}
				// Grad mutiert
				case 1:
				{
					unsigned char mask = 0x01;
					mask <<= rand()%8;
					ind->cmds[i].grad ^= mask;
					ind->cmds[i].grad %= MAX_GRAD;
					break;
				}
				// Zeit mutiert
				case 2:
				{
					unsigned short mask = 0x0001;
					mask <<= rand()%16;
					ind->cmds[i].sleep ^= mask;
					ind->cmds[i].sleep %= MAX_SLEEP_TIME;
					break;
				}
			}
		}
	}
}

void GAGenerator::print(Individual** inds, int len, char* label){
	printf("\n/////////////// %s ///////////////\n", label);
	for( int p = 0; p < len; p++){
	// Gib Indiviual auf dem Bildschirm aus

		// IndividuumNummer auf der Konsole ausgeben
		printf("%i: ", inds[p]->get_m_indNr());
		// Ein Individuum ausgeben
	    for(unsigned int i = 0; i < inds[p]->getLength(); i++)
		{
			printf("%d,%d,%d | ", inds[p]->cmds[i].servo_nr, 
								  inds[p]->cmds[i].sleep, 
								  inds[p]->cmds[i].grad);
		}
		//printf(" -> %u inv %u\n", inds[p]->getFitness(), inds[p]->m_invFitness);
		printf(" -> %u\n", inds[p]->getFitness());
		
    }
}

void GAGenerator::printPopulation(){
	Individual *all[POPULATION_SIZE];
	for ( int j = 0 ; j < POPULATION_SIZE ; j++ )
		all[j] = &population[j];
	print(all, POPULATION_SIZE, "All Individuals");
}






///////////////////////////////// OLD STUFF //////////////////////////////////
/*
void GAGenerator::mutate(Individual& ind)
{
	unsigned int ind_length = ind.getLength();
	CmdVecIter cmd_vec_iter;
	
	for(int i = 0; i < this->mutate_rate*ind.cmds.size(); i++)
	{
		// choose a cmd from individual per random
		cmd_vec_iter = ind.cmds.begin() + (rand() % ind_length);		

		switch(rand() % 3)
		{
			// Zeit mutieren
			case 0:
			{
  				unsigned mask = 0x00000001 << (rand() % (int)(16 * this->mutate_strength));
				cmd_vec_iter->sleep ^= mask;
				break;
			}
			// Grad mutieren
			case 1:
			{
				unsigned mask = 0x00000001 << (rand() % (int)(8 * this->mutate_strength));
				cmd_vec_iter->grad ^= mask;
				break;
			}
			// Welche Servo angesprochen wird
			case 2:
			{
  				unsigned mask = 0x00000001 << (rand() % (int)(8 * this->mutate_strength));
				cmd_vec_iter->servo_nr ^= mask;
				break;
			}
		}
	}
}
*/

/*
void GAGenerator::crossover(const Individual& mother, const Individual& father, Individual& child)
{
	int fatherCmd = rand() % father.getLength();
	int motherCmd = rand() % mother.getLength();

	child.cmds[j].servo_nr = father.cmds[fatherCmd].servo_nr;
	child.cmds[j].sleep	   = mother.cmds[motherCmd].sleep;
	child.cmds[j].grad	   = father.cmds[fatherCmd].grad;
}

*/

/*
void GAGenerator::doEvolution(void){
	Individual mother, father, son, daughter;
	int s_idx, d_idx, m_idx, f_idx;
	
//	int crossover_rate = rand() % POPULATION_SIZE;
	int crossover_rate = 1;
	cout << "crossover_rate: " << crossover_rate << endl;
	
	// generate a new population from the current population using select(), mutate() and crossover()
	for ( int j = 0 ; j < crossover_rate ; j++ )
	{
		// Selektiere Eltern
		select(mother, father, m_idx, f_idx, true);
		// Selektiere Kinder
		select(daughter, son, d_idx, s_idx, false);
		
		printf("\t son: %i daughter %i -> mother: %i, father: %i\n", s_idx, d_idx, m_idx, f_idx);
		crossover(population[m_idx], 
			population[f_idx], 
			population[d_idx],
			population[s_idx]
			);

		mutate(son);
		mutate(daughter);
	}
    this->generation++;
}
*/

/*
unsigned* GAGenerator::getStrongest(int n){
	unsigned* idxs = new unsigned[n];
	for ( int e = 0 ; e < n ; e++ )
		idxs[e] = -1;
	unsigned* values = new unsigned[n];
	// <values> auf 0 setzten
	for ( int h = 0 ; h < n ; ++h )
		values[h] = 0;

	for ( int j = 0 ; j < POPULATION_SIZE ; j++ ){
		bool stop = false;
		for ( int i = 0 ; i < n && !stop ; i++ )
			if ( population[j].getFitness() > values[i] ){
				eaux::right_shift(values, n, i, population[j].getFitness());
				eaux::right_shift(idxs, n, i, j);
				stop = true;
			}
	}
	printf("Strongest: \n");
	for ( int k = 0 ; k < n ; k++ )
		printf("v: %i, idx: %i\n", values[k], idxs[k]);
	printf("\n");
	delete values;
	return idxs;
}

unsigned* GAGenerator::getWeakest(int n){
	unsigned* idxs = new unsigned[n];
	for ( int e = 0 ; e < n ; e++ )
		idxs[e] = -1;
	unsigned* values = new unsigned[n];

	// <values> auf INT_MAX setzten
	for ( int h = 0 ; h < n ; ++h )
		values[h] = INT_MAX;

	for ( int j = 0 ; j < POPULATION_SIZE ; j++ ){
		bool stop = false;
		for ( int i = 0 ; i < n && !stop ; i++ )
			if ( population[j].getFitness() < values[i] ){
				eaux::right_shift(values, n, i, population[j].getFitness());
				eaux::right_shift(idxs, n, i, j);
				stop = true;
			}
	}
	printf("Weakest: \n");
	for ( int k = 0 ; k < n ; k++ )
		printf("v: %i, idx: %i\n", values[k], idxs[k]);
	printf("\n");
	delete values;
	return idxs;
}
*/

/**
	Selektiert 2 Individuen aus der gesamten Population.
	'Random' - rein zufllig
	'Fitness' - die strksten
	<parents> -> wenn 'true' werden Eltern ausgewhlt => die strksten
			  -> wenn 'false' werden Kinder ausgewhlt => die schwchsten
			  spielt eine Rolle nur wenn 'Fitness' das aktuelle Modus ist.
*/
/*
void GAGenerator::select(Individual &ind1, Individual &ind2, 
						 int &idx1, int &idx2, bool parents)
{
    switch(this->selectionMode)
    {
        case Random:
			idx1 = rand()%POPULATION_SIZE;
			ind1 = population[idx1];
			idx2 = rand()%POPULATION_SIZE;
			ind2 = population[idx2];
			break;
		case Fitness:
			unsigned* ind_idxs;
			if ( parents )
				ind_idxs = getStrongest(2);
			else
				ind_idxs = getWeakest(2);

			idx1 = ind_idxs[0];
			idx2 = ind_idxs[1];
			ind1 = population[idx1];
			ind2 = population[idx2];
			delete ind_idxs;
			break;
    }
}
*/

/*
void GAGenerator::crossover(const Individual& mother, const Individual& father, Individual& son, Individual& daughter)
{
	int length = __min(father.getLength(), mother.getLength());
	son.cmds.resize(length);
	daughter.cmds.resize(length);

	for ( int j = 0 ; j < length ; j++ )
	{
		son.cmds[j].servo_nr		= father.cmds[j].servo_nr;
		daughter.cmds[j].servo_nr	= mother.cmds[j].servo_nr;
		
		son.cmds[j].sleep			= mother.cmds[j].sleep;
		daughter.cmds[j].sleep		= father.cmds[j].sleep;
		
		son.cmds[j].grad			= father.cmds[j].grad;
		daughter.cmds[j].grad		= mother.cmds[j].grad;
	}
}
*/