#ifndef _CLASS_GA_GENERATOR_
#define _CLASS_GA_GENERATOR_

#include "Individual.h"
#include "PopulationGenerator.h"
#include <limits.h>

class GAGenerator: public PopulationGenerator
{
public:
	GAGenerator();
    ~GAGenerator();
	// virtual method
	virtual Individual* getPopulation(void);
    unsigned int getGenerationNr() const;
	void setMutateRate(float mutate_rate);
	float getMutateRate() const;

protected:
	void random_group(Individual** group, int size);
	/** Selektiert <n> Individuen aus der Gruppe <rand_group> nach dem Tournament-Prinzip
	 *	Wenn <parents> true ist, werden die Individuen proportional zu ihren Fitness ausgewhlt
	 *	Wenn false -> umgekehrt proportional
	 *	<size> = Anzahl der Individuen in <group>
	 */
	void tournamentSelection(Individual** group, int size, Individual** winners, int n, bool parents);
	/** <ind_count> Anzahl von <parents> erzeugen <ind_count> <children>
	 */
	void crossover(Individual** parents, Individual** children, unsigned ind_count);
	/** Mutiere Individuen aus der Population
	 */
	void mutate();

	/** Gibt die Individuen auf dem Bildschirm aus.
	 */
	void print(Individual** inds, int len, char* label);
	void printPopulation();

    void reset(void);
	void createInitialPopulation(void);
	void doEvolution(void);
    void deletePopulation(void);
// member variables
private:
	Individual* population; ///> the current population of individuals
    unsigned iteration; ///> the current generation
	
	// Wie viele Individuen mutieren sollen
	// 0.0 = keine mutieren, 1 = alle mutieren
	float mutate_rate;
};

inline unsigned int GAGenerator::getGenerationNr() const{
    return this->iteration;
}

inline void GAGenerator::setMutateRate(float mutate_rate){
	this->mutate_rate = mutate_rate;
}

inline float GAGenerator::getMutateRate() const{
	return this->mutate_rate;
}

#endif