#include <cstdlib>
#include <fstream>
#include "Individual.h"

unsigned Individual::m_nrGen = 0;

/*
 * Erzeugt ein Individuum zuflliger "Lnge" mit Fitness-Wert von 0
 */
Individual::Individual()
{
	this->m_indNr = this->m_nrGen++;
	this->mFitness = 0;
	this ->mTime = 0;
	this->m_invFitness = 0;
	this->length = (unsigned) (rand() % (MAX_CMD_COUNT-1))+1;
//	this->length = 5;
	
	unsigned char tmp_servo_nr, tmp_grad;
	unsigned short tmp_sleep;
	for (unsigned int j = 0 ; j < length ; j++ )
	{
		tmp_servo_nr = (unsigned char)(rand() % 11);
		tmp_sleep = (unsigned short) (rand() % MAX_SLEEP_TIME);
		tmp_grad = (unsigned char) (rand() % 180);
		this->cmds.push_back(Command(tmp_servo_nr, tmp_sleep, tmp_grad));
	}
//	setFitness(10000*(rand()%3)+1);
}

void Individual::recreate(CmdVector cmds, unsigned len){
	this->cmds = cmds;
	this->length = len;
	this->mFitness = 0;
	this->mTime = 0;
	this->m_invFitness = 0;
}

void Individual::load(const char* fileName) 
{
	this->cmds.clear();
	this->length = 0;
	this->mFitness = 0;
	this->mTime = 0;
	this->m_invFitness = 0;

	fstream file;
	file.open(fileName, ios::in);
	file >> this->length;

	for(int i=0; i<length; i++)
	{
		int servo_nr = 0;
		int sleep = 0;
		int grad = 0;
		file >> servo_nr;
		file >> sleep;
		file >> grad;
		this->cmds.push_back(Command(servo_nr, sleep, grad));
	}
	file.close();
}

void Individual::save(const char* fileName)
{
	fstream file;
	file.open(fileName, ios::out);
	
	file << (int) this->cmds.size() << " " ;
	for(int i=0; i<this->length; i++)
	{
		file << (int) this->cmds[i].servo_nr << " ";
		file << (int) this->cmds[i].sleep << " ";
		file << (int) this->cmds[i].grad << " ";
	}
	file.close();
}