#ifndef _CLASS_INDIVIDUAL_
#define _CLASS_INDIVIDUAL_

#include <time.h>
#include <stdlib.h>
#include <vector>
using namespace std;

#define		MAX_CMD_COUNT		30
#define		MAX_SLEEP_TIME		200
#define		POPULATION_SIZE		25
#define		SERVO_COUNT			11
#define		MAX_GRAD			180

class Command
{
    public:
		unsigned char servo_nr, grad;
		unsigned short sleep;
    	
	    Command(unsigned char servo_nr = 0, unsigned short sleep = 0, unsigned char grad = 0)
	    {
		    this->servo_nr = servo_nr;
		    this->sleep = sleep;
		    this->grad = grad;
	    }
};

typedef std::vector <Command> CmdVector;
typedef CmdVector::iterator CmdVecIter;

class Individual
{
public:
	Individual();

	void setFitness(float fitness){ this->mFitness = fitness;}
	void setTime(float time){ this->mTime = time;}
	unsigned int getFitness()const{ return this->mFitness;}
	unsigned int getTime()const{ return this->mTime;}
	unsigned int getLength()const{ return length;}
	unsigned get_m_indNr()const{ return this->m_indNr;}
	void recreate(CmdVector cmds, unsigned len);
	void load(const char* fileName);
	void save(const char* fileName);

// member variables
public:
	// Vector mit den Befehlen
	CmdVector cmds;
	// wird bei der Tournament-Selection bentigt
	unsigned m_invFitness;

private:
	float mFitness;
	float mTime;
	unsigned length;
	// eindeutige Nummer jedes Individuums
	unsigned m_indNr;
	// Zhler, der den Individuen Nummern vergibt
	static unsigned m_nrGen;
};

#endif