#include <iostream>
#include <fstream>
#include <process.h>
#include <conio.h>
#include "Manager.h"


Manager::Manager(Evaluator* evaluator, PopulationGenerator* pop_gen){
	this->evaluator = evaluator;
    this->pop_gen = pop_gen;
    this->eventKill = CreateEvent(NULL, TRUE, FALSE, NULL);
}


bool Manager::startUp()
{
	CreateThread(NULL, 0, managerThread, (void*)(this), 0, &this->threadID);
    return true;
}


void Manager::shutDown()
{
	SetEvent(this->eventKill);
}


void Manager::logging(Individual* population, int populationSize)
{
	std::fstream file;
	
	char filename[256];
	struct tm *newtime;	
    time_t long_time;

    time( &long_time );
    newtime = localtime( &long_time );
	sprintf(filename, "population_%d-%d-%d", newtime->tm_hour, newtime->tm_min, newtime->tm_sec); 

	float best = 0.0, worst = 0.0, avarage = 0.0, time = 0.0;
	int bestIndex = 0;

	file.open(filename, ios::out);
	
	best = worst = avarage = time = 0;
	for(int i=0; i<populationSize; i++)
	{
		float f = population[i].getFitness();
		if(f>best) 
		{ 
			best = f;
			bestIndex = i;
		}
		if(f<worst) worst = f;
		avarage += f;
		
		for(int j=0; j<population[i].cmds.size(); j++) 
		{
			file << (int) population[i].cmds[j].servo_nr << ",";
			file << (int) population[i].cmds[j].grad << ",";
			file << (int) population[i].cmds[j].sleep << ",";
		}
		file << endl;
		time += population[i].getTime();
	}
	avarage = avarage/populationSize;

	file << endl << "Bester: " << best << endl;
	file << "Schlechtester: " << worst << endl;
	file << "Fitness der Population: " << avarage << endl;
	file << "Gebrauchte Zeit: " << time << endl << endl;
	file.close();

	sprintf(filename, "best_%d-%d-%d", newtime->tm_hour, newtime->tm_min, newtime->tm_sec); 
	population[bestIndex].save(filename);
}


DWORD WINAPI managerThread(void* param)
{
	srand((unsigned int) time(NULL));

    Manager* manager = (Manager*) param;
    while(WaitForSingleObject(manager->eventKill, 0) == WAIT_TIMEOUT)
	{        
		// Beim ersten Aufruf wird eine zufllige Population erzeugt,
		// sonst wird aus der aktuellen Population durch selection, crossover und mutation
		// die neue gebildet
		Individual* population = manager->pop_gen->getPopulation();
		
		// Gib die Population auf dem Bildschirm aus
		// und evaluiere die Individuen in der aktuellen Population
		if(!manager->evaluator->startEvaluation(population, POPULATION_SIZE))
		{
			char* buffer;
			DWORD error = GetLastError();
			if(error != ERROR_SUCCESS)
			{
				FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, NULL, error, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &buffer, 0, NULL);
				std::cout << "Error Message: " << buffer << std::endl;
			}
			return 0;
		}

		// speichert die population
		manager->logging(population, POPULATION_SIZE);
    }

	return 1;
}