#ifndef _MANAGER_H_
#define _MANAGER_H_

#include <windows.h>
#include "PopulationGenerator.h"
#include "Evaluator.h"

class Manager
{
	private:
		Evaluator* evaluator;
		PopulationGenerator* pop_gen;
		HANDLE  eventKill;
		DWORD threadID;

	public:
		Manager(Evaluator* evaluator, PopulationGenerator* pop_gen);
		bool startUp();
		void shutDown();
		void logging(Individual* population, int populationSize);
		DWORD getThreadID();

	private:
		friend DWORD WINAPI managerThread(void* param);
};

inline DWORD Manager::getThreadID()
{
	return this->threadID;
}

#endif
