#include <cassert>
#include <iostream>
#include "MouseInput.h"


MouseInput::MouseInput()
{
	this->mEventKill = NULL;
    this->mCOM = NULL;
	this->mListener = 0;
	this->mThreadID = 0;
	this->mXMovement = 0;
	this->mYMovement = 0;
}


bool MouseInput::Open()
{

    HRESULT hr = CoInitialize(NULL);
    if(FAILED(hr)) return false;

	this->mCOM = CreateFile("COM1", GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if(this->mCOM == INVALID_HANDLE_VALUE) return false;
	
	DCB dcb;	
	ZeroMemory(&dcb, sizeof(DCB));
    dcb.BaudRate = 1200;
	dcb.ByteSize = 7;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	dcb.fDtrControl = DTR_CONTROL_ENABLE;
	dcb.fRtsControl = RTS_CONTROL_ENABLE;
	if(!SetCommState(this->mCOM, &dcb)) return false;

	if(!SetCommMask(this->mCOM, EV_RXCHAR)) return false;

    PurgeComm(this->mCOM, PURGE_TXCLEAR);
    PurgeComm(this->mCOM, PURGE_RXCLEAR);

	COMMTIMEOUTS timeout;
	ZeroMemory(&timeout, sizeof(COMMTIMEOUTS));
	timeout.ReadIntervalTimeout = MAXDWORD;
	timeout.ReadTotalTimeoutMultiplier = MAXDWORD;
	timeout.ReadTotalTimeoutConstant = 1000; // one second timeout
	timeout.WriteTotalTimeoutMultiplier = 0;
	timeout.WriteTotalTimeoutConstant = 0;
	if (!SetCommTimeouts(this->mCOM, &timeout)) return false;

	ZeroMemory(&this->mOverlapped, sizeof(OVERLAPPED));
	this->mOverlapped.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);

    return true;
}


void MouseInput::Close()
{
	CloseHandle(this->mEventKill);
	this->mEventKill = NULL;

	PurgeComm(this->mCOM, PURGE_RXABORT | PURGE_RXCLEAR | PURGE_TXCLEAR | PURGE_TXABORT);
    CloseHandle(this->mCOM);
	this->mCOM = NULL;
}


bool MouseInput::StartUp()
{	
	assert(this->mCOM && this->mListener);
	if(this->mThreadID != 0) return false;
	
	this->mEventKill = CreateEvent(NULL, TRUE, FALSE, NULL);
	CreateThread(NULL, 0, ListenMouseThread, (void*)(this), 0, &this->mThreadID);
	return true;
}


void MouseInput::ShutDown()
{
	SetEvent(this->mEventKill);
}


DWORD WINAPI ListenMouseThread(void* param)
{
	MouseInput* mouseInput	= (MouseInput*) param;
	HANDLE		events[2];
	COMSTAT		comState;
	DWORD		dwEvtMask;
	DWORD		dwError		= 0;
	bool		quit		= false;

	mouseInput->mXMovement = 0;
	mouseInput->mYMovement = 0;
	
	events[0] = mouseInput->mOverlapped.hEvent;
	events[1] = mouseInput->mEventKill;

	ClearCommError(mouseInput->mCOM, &dwError, &comState);

	while(true)
	{
/*
		WaitCommEvent(mouseInput->mCOM, &dwEvtMask, &mouseInput->mOverlapped);
		ClearCommError(mouseInput->mCOM, &dwError, &comState);
   
		switch(WaitForMultipleObjects(2, events, FALSE, INFINITE))
		{
			case WAIT_OBJECT_0:
				ResetEvent(events[0]);
				if(dwEvtMask & EV_RXCHAR)
				{
					unsigned long iBytesRead = 0;
					BYTE buffer[3];
					
					ZeroMemory(&buffer, 3);
					while(1)
					{
						unsigned long iBytesReadThisTime = 0;
						BOOL bRead;

						bRead = ReadFile(mouseInput->mCOM, &buffer[iBytesRead], 3 - iBytesRead, &iBytesReadThisTime, &mouseInput->mOverlapped);
						iBytesRead += iBytesReadThisTime;
						
						if(bRead == FALSE && GetLastError() == ERROR_IO_PENDING)
						{
							Sleep(2);
							continue;
						}
						else
						{
							break;
						}
					}

					//char x = ((buffer[0] & 0x4)<<6) | (buffer[1] & 0x3F);
					//char y = ((buffer[0] & 0xC)<<4) | (buffer[2] & 0x3F);			
					long x = (buffer[0] & 0x20) ? buffer[1] : -buffer[1];
					long y = (buffer[0] & 0x10) ? buffer[2] : -buffer[2];

					std::cout << "x: " << (int) x << "  y: " << (int) y << std::endl;

					mouseInput->mXMovement += x;
					mouseInput->mYMovement += y;
					
			
					//while(!PostThreadMessage(mouseInput->mListener, MOUSE_MSG, x, y)) Sleep(10);			
				}
				break;

			case WAIT_OBJECT_0 + 1:
				ResetEvent(events[1]);
				quit = true;
				break;

			case WAIT_FAILED:
				break;
		}
*/

		WaitCommEvent(mouseInput->mCOM, &dwEvtMask, &mouseInput->mOverlapped);
		ClearCommError(mouseInput->mCOM, &dwError, &comState);
		switch(WaitForMultipleObjects(2, events, FALSE, INFINITE))
		{
			case WAIT_OBJECT_0:
				ResetEvent(events[0]);
				if(dwEvtMask & EV_RXCHAR)
				{
					BYTE buffer[3];
					unsigned long count = 0;
					BOOL read = false;

					while(1)
					{
						ZeroMemory(buffer, sizeof(buffer));
						// read until start byte
						while(1)
						{
							read = ReadFile(mouseInput->mCOM, &buffer[0], 1, &count, &mouseInput->mOverlapped);
							if(!read) break; // nothing to read - mmhh ?
							if(buffer[0] & 0x40) break; // that's my start byte 
						}

						if(!read) break; // there was nothing to read
						
						ReadFile(mouseInput->mCOM, &buffer[1], 2, &count, &mouseInput->mOverlapped);
												
												
						int x = ((buffer[0] & 0x03) << 6) + (buffer[1] & 0x3F);
						if(x > 127) x = x - 256;
						int y = ((buffer[0] & 0x0C) << 4) + (buffer[2] & 0x3F);	
						if(y > 127) y = y - 256;
						y = -y;

						if(buffer[1]==0 && (buffer[0] & 0x03)) x = 0;
						if(buffer[2]==0 && (buffer[0] & 0x0C)) y = 0;

						mouseInput->mXMovement += x;
						mouseInput->mYMovement += y;
						// std::cout << "x: " << x << " y: " << y << std::endl;

						// go on, look for further bytes
					}
				}	
			break;

			case WAIT_OBJECT_0 + 1:
				ResetEvent(events[1]);
				quit = true;
				break;

			case WAIT_FAILED:
				break;
		}

		if(quit) break;

	}

	mouseInput->mThreadID = 0;
	return 1;
}