#ifndef MOUSE_INPUT_H
#define MOUSE_INPUT_H

#include <windows.h>

#define MOUSE_MSG WM_USER+1

class MouseInput
{
    public:
        MouseInput();
		bool Open();
		void Close();
        bool StartUp();
	    void ShutDown();
		void SetListener(DWORD listener);
		long GetXMovement();
		long GetYMovement();
 
    private:
		friend DWORD WINAPI ListenMouseThread(void* param);

        HANDLE		mEventKill;
        HANDLE		mCOM;
		OVERLAPPED	mOverlapped;
		DWORD		mListener;
		DWORD		mThreadID;
		long		mXMovement;
		long		mYMovement;
};

inline long MouseInput::GetXMovement()
{
	return this->mXMovement;
}

inline long MouseInput::GetYMovement()
{
	return this->mYMovement;
}

inline void MouseInput::SetListener(DWORD listener)
{
	this->mListener = listener;
}

#endif
