#include <ctime>
#include <cstdlib>
#include <iostream>

#include "Manager.h"
#include "GAGenerator.h"
#include "KonsoleElfeEvaluator.h"
#include "ElfeEvaluator.h"

Manager* manager;
Evaluator *eval;
GAGenerator* ga_gen;


void init(){
	srand((unsigned int) time(NULL));

	ga_gen = new GAGenerator();

	std::cout << "Evaluate on AKSEN-Board? (y/n) ";
	char r;
	r = getchar();
	fflush(stdin);

	if ( r == 'n' || r == 'N' )
	{
		eval = new KonsoleElfeEvaluator();
	}
	else
	{
		eval = new ElfeEvaluator();
	}

	manager = new Manager(eval, ga_gen);

    ga_gen->setMutateRate(0.1f);
}


void main(void)
{
	init();
	eval->startUp();
    manager->startUp();
	while(1);
    manager->shutDown();
    eval->shutDown();
}