#include <ctime>
#include <cstdlib>
#include <iostream>
#include <windows.h>

void printBinary(unsigned char c)
{
	if(c & 0x80) std::cout << 1; else std::cout << 0;
	if(c & 0x40) std::cout << 1; else std::cout << 0;
	if(c & 0x20) std::cout << 1; else std::cout << 0;
	if(c & 0x10) std::cout << 1; else std::cout << 0;
	if(c & 0x08) std::cout << 1; else std::cout << 0;
	if(c & 0x04) std::cout << 1; else std::cout << 0;
	if(c & 0x02) std::cout << 1; else std::cout << 0;
	if(c & 0x01) std::cout << 1; else std::cout << 0;
}


int main(void)
{
	// init
    HANDLE		mCOM = NULL;
	OVERLAPPED	mOverlapped;

	HRESULT hr = CoInitialize(NULL);
    if(FAILED(hr)) return 0;

	mCOM = CreateFile("COM1", GENERIC_WRITE |GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	//mCOM = CreateFile("COM1", GENERIC_WRITE | GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if(mCOM == INVALID_HANDLE_VALUE) return 0;
	
	DCB dcb;	
	ZeroMemory(&dcb, sizeof(DCB));
    dcb.BaudRate = 1200;
	dcb.ByteSize = 7;
	dcb.Parity = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	dcb.fDtrControl = DTR_CONTROL_ENABLE;
	dcb.fRtsControl = RTS_CONTROL_ENABLE;
	if(!SetCommState(mCOM, &dcb)) return 0;

	if(!SetCommMask(mCOM, EV_RXCHAR)) return 0;

    PurgeComm(mCOM, PURGE_TXCLEAR);
    PurgeComm(mCOM, PURGE_RXCLEAR);

	COMMTIMEOUTS timeout;
	ZeroMemory(&timeout, sizeof(COMMTIMEOUTS));
	timeout.ReadIntervalTimeout = MAXDWORD;
	timeout.ReadTotalTimeoutMultiplier = MAXDWORD;
	timeout.ReadTotalTimeoutConstant = 1000; // one second timeout
	timeout.WriteTotalTimeoutMultiplier = 0;
	timeout.WriteTotalTimeoutConstant = 0;
	if (!SetCommTimeouts(mCOM, &timeout)) return 0;

	ZeroMemory(&mOverlapped, sizeof(OVERLAPPED));
	mOverlapped.hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);

	// listen mouse
	COMSTAT		comState;
	DWORD		dwEvtMask;
	DWORD		dwError		= 0;
	
	ClearCommError(mCOM, &dwError, &comState);

	while(true)
	{
		WaitCommEvent(mCOM, &dwEvtMask, &mOverlapped);
		ClearCommError(mCOM, &dwError, &comState);
		if(WaitForSingleObject(mOverlapped.hEvent, INFINITE) == WAIT_OBJECT_0)
		{
			ResetEvent(mOverlapped.hEvent);
			if(dwEvtMask & EV_RXCHAR)
			{
				BYTE buffer[3];
				unsigned long count = 0;
				BOOL read = false;

				while(1)
				{
					ZeroMemory(buffer, sizeof(buffer));
					// read until start byte
					while(1)
					{
						read = ReadFile(mCOM, &buffer[0], 1, &count, &mOverlapped);
						if(!read) break; // nothing to read - mmhh ?
						//printBinary(buffer[0]);
						//std::cout << " ";
						if(buffer[0] & 0x40) break; // that's my start byte 
					}

					if(!read) break; // there was nothing to read
					
					ReadFile(mCOM, &buffer[1], 2, &count, &mOverlapped);
					
					printBinary(buffer[1]);
					std::cout << " ";
					printBinary(buffer[2]);
					std::cout << " ";
					
											
					int x = ((buffer[0] & 0x03) << 6) + (buffer[1] & 0x3F);
					if(x > 127) x = x - 256;
					int y = ((buffer[0] & 0x0C) << 4) + (buffer[2] & 0x3F);	
					if(y > 127) y = y - 256;
					y = -y;

					if(buffer[1]==0 && (buffer[0] & 0x03)) x = 0;
					if(buffer[2]==0 && (buffer[0] & 0x0C)) y = 0;

					std::cout << "x: " << x << " y: " << y << std::endl;

					// go on, look for further bytes
				}
			}				
		}
	}

	// clean up
	PurgeComm(mCOM, PURGE_RXABORT | PURGE_RXCLEAR | PURGE_TXCLEAR | PURGE_TXABORT);
    CloseHandle(mCOM);
	mCOM = NULL;

	return 1;
}
