#include <ctime>
#include <cstdlib>
#include <iostream>
#include <windows.h>
#include "aksenio.h"
#include "individual.h"



int main(void)
{	
	AksenIO aksenIO;
	Individual individual;
	individual.load("best_13-35-50");

	if(!aksenIO.Open()) return 0;

	char c;
	char buffer[256];
	unsigned long count;
	bool skip = false;
	for(unsigned int p = 0; p < 100; p++)
    {    
		// send syn
		c = 's';
		if(!aksenIO.Send(&c, 1, &count)) return 0;
		std::cout << "s ";

		// handshaking
		while(1)
		{			
			// recieve ack
			c = 0;
			if(aksenIO.Recieve(&buffer[0], 5, &count)) 
			{
				if(count>1) c = buffer[count-1];
				else c = buffer[0];
				std::cout << c << " ";
				if(c == 'a') break;
				if(c == 'n') {
					// send syn
					c = 's';
					if(!aksenIO.Send(&c, 1, &count)) return 0;
					std::cout << "s ";
				}
			}
		}


		// sending commands
        for(unsigned int i = 0; i<individual.getLength(); i++)
        {
			sprintf(buffer, "%d,%d,%d,", individual.cmds[i].servo_nr, individual.cmds[i].grad, individual.cmds[i].sleep);			
			if(!aksenIO.Send(buffer, strlen(buffer), &count))
			{
				std::cout << std::endl;
				std::cout << "Error: Sending cmd failed!" << std::endl;
				return 0;
			}
				
			// recieve ack
			while(1)
			{		
				c = 0;
				if(aksenIO.Recieve(&c, 1, &count)) 
				{
					std::cout << c << " ";
					if(c == 'a')
					{
						break;
					}
					else if(c == 'n')
					{
						std::cout << std::endl;
						std::cout << "Warning: Skipping invalid individual!" << std::endl;
						skip = true;
						break;
					}
					else
					{
						std::cout << std::endl;
						std::cout << "Error: Expected Ack!" << std::endl;
						skip = true;
						break;
					}
				}
				std::cout << "lese";
			}

			if(skip) break;
		}
		
		if(!skip)
		{
			std::cout << "f ";
			// send fin
			c = 'f';
			if(!aksenIO.Send(&c, 1, &count)) return 0;
			
			// recieve count
			while(1)
			{
				c = 0;
				if(aksenIO.Recieve(&c, 1, &count))
				{
					std::cout << (int) c << " ";
					if(c != individual.getLength())
					{
						std::cout << std::endl << "Error: Wrong Cmd Count!" << std::endl;
						return 0;
					}
					else
					{
						std::cout << std::endl << "Info: Send to Aksen." << std::endl;
						break;
					}
				}
			}


			// send ack
			std::cout << "a ";
			c = 'a';
			if(!aksenIO.Send(&c, 1, &count)) return 0;


			while(1)
			{
				bool aksenFinished = false;

				// look for ack for stopping evaluation
				char c = 0;
				unsigned long count = 0;
				if((aksenIO.Recieve(&c, 1, &count) && c=='f'))
				{
					std::cout << "Info: Aksen finished." << std::endl;
					break;
				}
			}
		}
	}

	return 1;
}
